<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* A Module with a contact form
*
* @package nukeevent.modules.contact
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/**
*Show the Submit Form.
*/
function drawForm($arrData)
{
    global $neConfig, $neDb, $neTheme, $neSession,$neModuleName;
	
    $tpl = $neTheme->getTemplate($neModuleName,'contactform.tpl');
    $tpl->setVariable(array(
        'LABEL_CONTACT' => neTranslate('contact'),
        'LABEL_CONTACT_FORM' => neTranslate('contact_form'),
        'LABEL_SENDER_NAME' => neTranslate('sender_name'),
        'LABEL_SENDER_EMAIL' => neTranslate('sender_email'),
        'LABEL_SUBJECT' => neTranslate('subject'),
        'LABEL_MESSAGE' => neTranslate('message'),
        'LABEL_SUBMIT' => neTranslate('submit'),

        'TEXT' => $arrData['text'],
        'FORM_ACTION' => MODULE_LOADER.'?mod='.$neModuleName,
        'OP' => 'submit',
        'SENDER_NAME' => $arrData['sender_name'],
        'SENDER_EMAIL' => $arrData['sender_email'],
        'SUBJECT' => $arrData['subject'],
        'MESSAGE' => $arrData['message']
    ));
    $tpl->show();
}

function drawContactForm() 
{
	global $neTheme,$neSession;
	require_once('modules/content/content_functions.php');
	$arrData  = array(
	   'text' => getContent('module_contact'),
		'sender_name' => $neSession->getName(),
		'sender_email' => $neSession->email,
		'subject' => '',
		'message' => ''
	);
	drawForm($arrData);
	$neTheme->drawSite(neTranslate('contact_form'));
}

function showSubmit()
{
    global $neTheme, $neModuleName;
    $tpl = $neTheme->getTemplate($neModuleName,'feedback_send.tpl');
    $tpl->touchBlock('form');
    $tpl->show();
    $neTheme->drawSite();
}


/**
* The Functions File for the Jirca Module:
*
* @package nukeevent.modules.jirca
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

function submitForm($arrData)
{
    global $neTheme,$neConfig;
    $errors = false;
    $senderName = trim(neCheckText($arrData['sender_name']),'plain');
    $senderEmail = trim(neCheckText($arrData['sender_email']),'plain');
    $subject = trim(neCheckText($arrData['subject']),'plain');
    $message = trim(neCheckText($arrData['message']),'plain');
    if ( empty($senderName) ) {
        $errors .= neTranslate('no_sender_name').'<br />';
    }
    if ( empty($senderEmail) ) {
        $errors .= neTranslate('no_sender_email').'<br />';
    }
    if ( empty($subject) ) {
        $errors .= neTranslate('no_subject').'<br />';
    } 
    if ( empty($message) ) {
        $errors .= neTranslate('no_message').'<br />';
    } 
    if ($errors != false) {
        drawForm(array(
        	'text' => '<p class="error">'.$errors.'</p>',
        	'sender_name' => $senderName,
        	'sender_email' => $senderEmail,
        	'subject' => $subject,
        	'message' => $message
        ));
        $neTheme->drawSite();
    } else {
        $result = mail(
        	$neConfig['notify']['email'],
        	$subject,
        	$message,
            "From: $senderName <$senderEmail>\r\n"
            ."X-Mailer: PHP/" . phpversion() 
        );
        if ($result) {
            neRedirect(MODULE_LOADER.'?mod=contact&op=show_submit');
        }
    }   
}

?>
