<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Functions for bringing the Content to the users. 
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.7 $
*/

function getEditLink($strName) {
    global $neTheme;
    $strReturn = '<a href="'.MODULE_LOADER.'?mod=content&amp;op=edit&amp;';
    $strReturn .= 'name='.urlencode($strName).'">';
    $strReturn .= $neTheme->getImage('edit',neTranslate('edit'));
    $strReturn .= '</a>';
    return($strReturn);
}

function getExportLink($strName) {
    global $neTheme;
    $strReturn = '<a href="'.MODULE_LOADER.'?mod=content&amp;op=export&amp;';
    $strReturn .= 'name='.urlencode($strName).'">';
    $strReturn .= $neTheme->getImage('save',neTranslate('export'));
    $strReturn .= '</a> ';
    return($strReturn);
}

function getDeleteLink($strName) {
    global $neTheme;
    $strJScript  = "return confirmBox(this,'";
    $strJScript .= "$strName\\n".neTranslate('text-delete_content');
    $strJScript .= "')";

    $strReturn = '<a onclick="'.$strJScript.'" href="'.MODULE_LOADER.'?mod=content&amp;op=delete&amp;';
    $strReturn .= 'name='.urlencode($strName).'" onclick".$strJScript.">';
    $strReturn .= $neTheme->getImage('delete',neTranslate('delete'));
    $strReturn .= '</a> ';
    return($strReturn);
}

function getActiveLink($strName,$intStatus) {
	global $neTheme;
    if ($intStatus == 1) {
	   $strReturn = '<a href="'.MODULE_LOADER
	   .'?mod=content&amp;op=deactivate&amp;name='
	   .$strName.'">'
	   .$neTheme->getImage('ledgreen',neTranslate('active'))
	   .'</a>';
    } else {
	   $strReturn = '<a href="'.MODULE_LOADER
	   .'?mod=content&amp;op=activate&amp;name='
	   .$strName.'">'
	   .$neTheme->getImage('ledred',neTranslate('inactive'))
	   .'</a>';
    }
return $strReturn;
}

/**
* Displays the Site.
*/
function getContent($strName)
{
    global $neConfig, $neSession, $neDb, $neTheme;
    $strQuery  = 'SELECT content, active ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name='$strName' " ;
    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__,$strQuery);
    if ($page['active'] == 1 or $neSession->isAdmin('content')){
        $strReturn = neFormatText($page['content'],'wiki');
    } else {
        $strReturn = '';
    }
    if ($neSession->isAdmin('content')){
        $strReturn .= '<div style="text-align:right">';
        $strReturn .= getActiveLink($page['active']);
        $strReturn .= getExportLink($strName);
        $strReturn .= getEditLink($strName);
        $strReturn .= '</div>';
    }
    return $strReturn;
}

function displayContent($strName)
{
    global $neConfig, $neSession, $neDb, $neTheme;
    $strQuery  = 'SELECT * FROM ';
    $strQuery .=  $neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name='$strName' " ;

    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__,$strQuery);
    if ($page == null) {
        $page['active'] = 0;
        $page['title'] = neTranslate('inactive_page');
        $page['content'] = neTranslate('text-inactive_page');
    }

    if (($page['active'] == 1) OR $neSession->isAdmin('content')){
        $tpl = $neTheme->getTemplate('content','content.tpl');
        $tpl->setVariable('TITLE',$page['title']);
        $tpl->setVariable('CONTENT',neFormatText($page['content'],'wiki'));
        if ($neSession->isAdmin('content')){
            $tpl->setVariable(array(
                'LABEL_CHANGED' => neTranslate('changed'),
                'AUTHOR' => neGetUserName($page['author']),
                'CHANGED' => neFormatText($page['changed']),
                'ACTIVE_LINK' => getActiveLink($strName),
                'EDIT_LINK' => getEditLink($strName),
                'EXPORT_LINK' => getExportLink($strName),
                'DELETE_LINK' => getDeleteLink($strName)
            ));
        }
        $tpl->parse();
        $tpl->show();
    } else {
        $neTheme->drawErrorPage(
            neTranslate('inactive_page'),
            neTranslate('text-inactive_page')
        );
    }
    $neTheme->drawSite(neFormatText($page['title']));
}
