<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Image Functions for the Content Manager
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

function deleteImage($strFilename) {
    global $neConfig,$neTheme;
    if (@unlink(IMAGE_DIR.$strFilename) ) {
        @unlink(THUMB_DIR.$strFilename);
        neRedirect(MODULE_LOADER.'?mod=content&op=admin_images');
    } else {
        $neTheme->drawErrorPage(
	    neTranslate('file_not_found'),
	    neTranslate('text-file_not_found').$strFilename
	);
    }    
}


function exportImage($strFile) {
    global $neConfig;
    $strName = basename($strFile);
    header('Content-Type: application/octet-stream');
    header('Expires: ' . gmdate('D, d M Y H:i:s') . ' GMT');
    header('Content-Disposition: attachment; filename="'.$strName.'"');
    header('Content-Disposition: inline; filename="'.$strName.'"');
    header('Cache-Control: must-revalidate, post-check=0, pre-check=0');
    header('Pragma: public');
    header('Pragma: no-cache');
    echo file_get_contents($strFile);
}
/**
*
*/
function createThumbnail($filename) 
{
    if (!is_dir(THUMB_DIR) ) {
        mkdir(THUMB_DIR,0777);
    }
    neResizeImage(IMAGE_DIR.$filename,THUMB_DIR.$filename,48,48);
}


/**
* searches  a Thumbnail for an Image.
* @returns string the Location of the Images
*/
function getThumbnail($filename){
	if (!is_file(THUMB_DIR.$filename) ) {
        createThumbnail($filename);
    }
    return(THUMB_DIR.$filename);
}

/**
* Show the uploaded Images
*/
function adminImages()
{
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $tpl = $neTheme->getTemplate($neModuleName,'admin_images.tpl');
    if (!is_dir('data/content') ) {
	mkdir('data/content');
    }
    if ( !$imageDir = dir('data/content') ) {
        $neTheme->drawErrorPage(neTranslate('no_data_directory'));
    }
    $neTheme->drawTitle(neTranslate('admin images'));
    $tpl->setVariable(array(
        'MESSAGE-ADMIN_IMAGES' => neTranslate('message-admin_images'),
        'LABEL_THUMBNAIL' => neTranslate('thumbnail'),
        'LABEL_FILENAME' => neTranslate('file_name'),
        'LABEL_FILESIZE' => neTranslate('file_size'),
        'LABEL_SIZE' => neTranslate('size'),
        'LABEL_FUNCTIONS' => neTranslate('functions'),
        'LABEL_UPLOAD' => neTranslate('upload')
    ));
    while( $imageFile = $imageDir->read() ) { 
        if ( ereg("^\.",$imageFile) ) { continue;}
        $tpl->setCurrentBlock('image');
        $filename = 'data/content/'.$imageFile;
        if (!list($width,$height,$type,$imgsize) = @getimagesize($filename)) {continue;}
        $tpl->setVariable(array(
            'THUMBNAIL' => getThumbnail($imageFile),
            'IMGSRC' => $filename,
	    'FILENAME' => $imageFile,
            'FILESIZE' => round(filesize($filename)/1024).' kB',
	    'SIZE' => "$width x $height",
        'EXPORT' => '<a href="'.MODULE_LOADER.'?mod=content&amp;op=export_image&amp;file='.$filename.'">'
	                .$neTheme->getImage('save',neTranslate('export',1)).'</a>', 
	    'DELETE' => '<a href="'.MODULE_LOADER.'?mod=content&amp;op=delete_image&amp;file='.$imageFile.'" onclick="confirmBox(this,\''.neTranslate('message-really_delete').'\')">'.$neTheme->getImage('delete',neTranslate('delete',1)).'</a>'
	));
        $tpl->parse('image');    
    }
    $tpl->show();
    $neTheme->drawSite();
}
?>
