<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Setup for the events module.
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

/**
* Installs News
*/
function install()
{
    global $neDb, $neConfig;
    addModule('events','Events');
    addAdminmenu('events','admin_events','Admin Events');
    addAdminmenu('events','new_event','Add Event');
    addAdminmenu('events','admin_locations','Admin Locations');
    addAdminmenu('events','new_location','Add Location');
    $strQuery  = 'CREATE TABLE '.$neConfig['db']['prefix']."_events (
		`event_id` int(20) NOT NULL auto_increment,
  		`event_topic` int(20) NOT NULL default '0',
  		`event_author` int(20) NOT NULL default '0',
  		`event_created` datetime NOT NULL default '0000-00-00 00:00:00',
  		`event_title` varchar(150) NOT NULL default '',
  		`event_location` int(22) default NULL,
  		`event_summary` text,
  		`event_detail` text,
  		`event_start` int(20) unsigned NOT NULL default '0',
  		`event_end` int(20) unsigned NOT NULL default '0',
  		`event_waiting` int(1) NOT NULL default '1',
  		`top_event` int(1) NOT NULL default '0',  PRIMARY KEY  (event_id)
	)";
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);
}

/**
* uninstalls the module
*/
function uninstall()
{
    global $neDb, $neConfig;
    removeModule('events','Events');
    removeAdminmenu('events');
    $strQuery  = 'DROP TABLE '.$neConfig['db']['prefix'].'_events';
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);
}

switch ($neOp){
    case 'install_module':
        install();
        $neTheme->drawSite();
        break;
    case 'uninstall_module':
        uninstall();
        $neTheme->drawSite();
        break;

}
?>