<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* A simple List view of the Events.
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
 * Displays the latest News.
 */
function displayView($intTopic=null) {
    global $neDb, $neTheme, $neSession, $neConfig;

    //Load the Template File
    $tpl = $neTheme->getTemplate('events','view_list.tpl');

    $today = date('Y-m-d');
    $tomorrow = date('Y-m').'-'.(date('d')+1);
    
    //first we show the events that are going on today...
    $strQueryToday  = 'SELECT event.*,topic_title,topic_id,topic_name,user_name ';
    $strQueryToday .= 'FROM '.$neConfig['db']['prefix'].'_events as event, ';
    $strQueryToday .= $neConfig['db']['prefix']."_topics, ";
    $strQueryToday .= $neConfig['db']['userprefix'].'_users ';
    $strQueryToday .= 'WHERE user_id = event_author ';
    $strQueryToday .= 'AND topic_id = event_topic ';
    $strQueryToday .= "AND event_waiting = '0' ";
    $strQueryToday .= "AND event_start < '$tomorrow' ";
    $strQueryToday .= "AND event_end >= '$today' ";
    if ($intTopic > 0 ) {
        $strQueryToday .= "AND event_topic = '$intTopic' ";
    }   
    $strQueryToday .="ORDER BY event_start ASC ";
    $eventsToday = $neDb->query($strQueryToday);
    neGetDbError($eventsToday,__LINE__,__FILE__,$strQueryToday);
    unset($strQueryToday);
    if ($eventsToday->numRows() > 0 ) {
        while ($event = $eventsToday->fetchRow(DB_FETCHMODE_ASSOC)) {
            $arrEventsToday[] = $event['event_id'];
            $tpl->setCurrentBlock('event_today');
            $strMorelink = MODULE_LOADER."?mod=events&amp;op=show_event&amp;id=".$event['event_id'];  
            $eventStart = strtotime($event['event_start']);
            $eventEnd = strtotime($event['event_end']);
            $eventCreated = strtotime($event['event_created']);
            $tpl->setVariable(array(
            'TODAY_EVENT_START_DATE' => neFormatTimestamp($eventStart,'date'),
            'TODAY_EVENT_START_TIME' => neFormatTimestamp($eventStart,'time'),
            'TODAY_EVENT_START_DATETIME' => neFormatTimestamp($eventStart,'date_time'),
            'TODAY_EVENT_END_DATE' => neFormatTimestamp($eventStart,'date'),
            'TODAY_EVENT_END_TIME' => neFormatTimestamp($eventStart,'time'),
            'TODAY_EVENT_END_DATETIME' => neFormatTimestamp($eventStart,'date_time'),
            'TODAY_EVENT_CREATED' => neFormatTimestamp($eventCreated,'datetime'),
            'TODAY_EVENT_AUTHOR' => neFormatText($event['user_name']),
            'TODAY_EVENT_TITLE' => neFormatText($event['event_title'],'plain'),
            'TODAY_EVENT_SUMMARY' => neFormatText($event['event_summary'],'plain'),
            'TODAY_EVENT_MORE_LINK' => $strMorelink,
            'TODAY_TOPIC_NAME' => neFormatText($event['topic_name'],'plain'),
            'TODAY_TOPIC_TITLE' => neFormatText($event['topic_title'],'plain'),
            'TODAY_TOPIC_ID' => (int) $event['topic_id'],
            'TODAY_TOPIC_LINK' => MODULE_LOADER.'?mod=event&amp;view=',
            'TODAY_EVENT_BIG_IMAGE' =>getBigImage($event['event_id'],$event['topic_name']),
            'TODAY_EVENT_SMALL_IMAGE' =>getSmallImage($event['event_id'],$event['topic_name'])
            ));
            if ($neSession->isAdmin('events')) {
                $tpl->setVariable(array(
                'TODAY_DELETE_LINK' => getDeleteLink($event['event_id'],$event['event_title']),
                'TODAY_EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_event&amp;id='.$event['event_id'].'">'.
                $neTheme->getImage('edit',neTranslate('edit')).'</a> ',
                'TODAY_EDIT_LINKS_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_links&amp;id='.$event['event_id'].'">'
                .$neTheme->getImage('link',neTranslate('edit_links')).'</a> '
                ));
            }   
            $tpl->parse('event_today');
        }   
        $eventsToday->free();
    } else {
    }    

    //fetch the upcoming events
    $strQuery  = 'SELECT event.*,topic_title,topic_id,topic_name,user_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events as event, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['userprefix'].'_users ';
    $strQuery .= 'WHERE user_id = event_author ';
    $strQuery .= 'AND topic_id = event_topic ';
    $strQuery .= 'AND event_waiting = \'0\' ';
    $strQuery .= "AND event_start >= '$tomorrow'";
    if ($intTopic > 0 ) {
        $strQuery .= "AND event_topic = '$intTopic' ";
    }   
    $strQuery .='ORDER BY event_start ASC ';
    $strQuery .= 'LIMIT 20';
    $eventsResult = $neDb->query($strQuery);
    neGetDbError($eventsResult,__LINE__,__FILE__,$strQuery);
    $tpl->setCurrentBlock('event');
    while($event = $eventsResult->fetchRow(DB_FETCHMODE_ASSOC)){
        $strMorelink = MODULE_LOADER."?mod=events&amp;op=show_event&amp;id=".$event['event_id'];  
        $eventStart = strtotime($event['event_start']);
        $eventEnd = strtotime($event['event_end']);
        $eventCreated = strtotime($event['event_created']);
        $tpl->setVariable(array(
            'EVENT_START_DATE' => neFormatTimestamp($eventStart,'date'),
            'EVENT_START_TIME' => neFormatTimestamp($eventStart,'time'),
            'EVENT_START_DATETIME' => neFormatTimestamp($eventStart,'date_time'),
            'EVENT_END_DATE' => neFormatTimestamp($eventStart,'date'),
            'EVENT_END_TIME' => neFormatTimestamp($eventStart,'time'),
            'EVENT_END_DATETIME' => neFormatTimestamp($eventStart,'date_time'),
            'EVENT_CREATED' => neFormatTimestamp($eventCreated,'datetime'),
            'EVENT_AUTHOR' => neFormatText($event['user_name']),
            'EVENT_TITLE' => neFormatText($event['event_title'],'plain'),
            'EVENT_SUMMARY' => neFormatText($event['event_summary'],'plain'),
            'EVENT_MORE_LINK' => $strMorelink,
            'TOPIC_NAME' => neFormatText($event['topic_name'],'plain'),
            'TOPIC_TITLE' => neFormatText($event['topic_title'],'plain'),
            'TOPIC_ID' => (int) $event['topic_id'],
            'TOPIC_LINK' => MODULE_LOADER.'?mod=event&amp;view=', //TODO:Topic verlinkung
            'EVENT_BIG_IMAGE' =>getBigImage($event['event_id'],$event['topic_name']),
            'EVENT_SMALL_IMAGE' =>getSmallImage($event['event_id'],$event['topic_name'])
        ));
        if ($neSession->isAdmin('events') ) {
            $tpl->setVariable(array(
            'DELETE_LINK' => getDeleteLink($event['event_id'],$event['event_title']),
            'EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_event&amp;id='.$event['event_id'].'">'.
            $neTheme->getImage('edit',neTranslate('edit')).'</a> ',
            'EDIT_LINKS_LINK' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=edit_links&amp;id='.$event['event_id'].'">'
            .$neTheme->getImage('link',neTranslate('edit_links')).'</a> '
            ));
        }   
        $tpl->parseCurrentBlock();
	 }	
    $eventsResult->free();
 
	//Show the waiting Articles
    if ($neSession->isAdmin('news') ) {
          $tpl->setCurrentBlock('admin');
          $tpl->setVariable(array(
		     'LABEL_EVENTS_WAITING' => neTranslate('events_waiting'),
			 'EVENTS_WAITING' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=admin_events">'.getNumEventsWaiting().'</a>',
			 'NEW_EVENT' => '<a href="'.MODULE_LOADER.'?mod=events&amp;op=new_event">'
			                 .$neTheme->getImage('new',neTranslate('new_article')).'</a>'
		));
	}
   $tpl->show();
   $neTheme->drawSite(neTranslate('events'));
}
?>