<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* All Functions to administrate the Modules.
*
* @package nukeevent.modules.module-admin
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/**
 * Adds an Module to NukeEvent.
 * This function inserts an Entry in the modules table 
 * and copies the module icon in the DATA_PATH
 *
 * @param string the name of the module (the directory of the module)
 * @param string the Title of the Module, which is vissible to the users.
 * @return boolean TRUE on succsess, FALSE when the insert fails. 
 */
function addModule($strModulename, $strTitle){
   global $neConfig, $neDb,$neDbWrite,$neDbWrite, $neTheme;
    
    // First Chack if the Module already exists
    $strQuery  = "SELECT module_id ";
    $strQuery .= "FROM ".$neConfig['db']['prefix']."_modules ";
    $strQuery .= "WHERE name='$strModulename'";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    
    //If the module does exist, we abort.
    if ($result->numRows() > 0){
        $neTheme->drawErrorpage(
            neTranslate('module_exists'),
            neTranslate('text-module_exists')
        );
        die();
    }
    //get the next free Module id
    $strQuery  = "SELECT module_id ";
    $strQuery .= "FROM ".$neConfig['db']['prefix']."_modules ";
    $strQuery .= "ORDER BY module_id DESC LIMIT 1";
    $intId = $neDb->getOne($strQuery);
    $intId = ($intId + 1);
    
    //insert the module in the modules table
    $strQuery  = "INSERT INTO ".$neConfig['db']['prefix']."_modules ";
    $strQuery .= "VALUES('$intId','$strModulename','0','0','$strTitle')";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);       
    
    /*now we try to install the fancy little module icon*/
    //create the image dir when needet:    
    if (!is_dir(IMAGE_DIR) ) {
        mkdir(IMAGE_DIR);
        chmod(IMAGE_DIR,0777);
    }
    //copy the image
    if (file_exists('modules/'.$strModulename.'/'.$strModulename.'.png') ){
        echo 'Installing '. $strModulename.'.png...<br/>';
        copy("modules/$strModulename/$strModulename.png",IMAGE_DIR.$strModulename.'.png') or
        trigger_error("could not copy $strModulename.png");
    } elseif (file_exists('modules/'.$strModulename.'/'.$strModulename.'.gif') ){
        echo 'Installing '. $strModulename.'.gif...<br/>';
        copy("modules/$strModulename/$strModulename.gif",IMAGE_DIR.$strModulename.'.gif') or
        trigger_error("could not copy $strModulename.gif");
    }

    //create the DATA_PATH
    if (!is_dir(DATA_PATH) ) {
        echo 'Creating '.DATA_PATH.'...<br/>';  
        mkdir(DATA_PATH,0777) or trigger_error("can not create ".DATA_PATH);
    }    

    //create a directory in the DATA_PATH
    if (!is_dir(DATA_PATH.$strModulename) ) {
        echo 'Creating '.DATA_PATH.$strModulename.'...<br/>';  
        mkdir(DATA_PATH.$strModulename,0777) or trigger_error("can not create ".DATA_PATH.$strModuleName);
    }
        
    //create a index.php Symlink for the module 
    if ($neConfig['module-admin']['create_symlinks'] ){
        echo 'Creating '. $strModulename.'.php Symlink ';
        symlink('index.php',$strModulename.'.php')  or trigger_error("could not create Symlink ".DATA_PATH.$strModuleName);
    }
}

/**
 * Uninstalls an installed Module
 */
function removeModule($strModulename){
   global $neConfig, $neDb, $neDbWrite, $neTheme;
    /* Delete the module entry */
    $strQuery = "DELETE FROM ".$neConfig['db']['prefix']."_modules ";
    $strQuery .= "WHERE name='$strModulename'";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);

    //remove the Symlink
    if (file_exists($strModulename.'.php') ){
        echo 'Removing '. $strModulename.'.php...<br/>';
        unlink($strModulename.'.php') or trigger_error("could not delete $strModulename.php");
    }
    //remove the Module Icon
    echo 'Removing '. $strModulename.' image...<br/>';
    @unlink('images/modules/'.$strModulename.'.png');
    @unlink('images/modules/'.$strModulename.'.gif');
    @unlink('images/modules/'.$strModulename.'.jpg');

    //purge the moduledir in the DATA_PATH
    if (is_dir(DATA_PATH.$strModulename) ) {
    	echo 'Deleting '.DATA_PATH.$strModulename.'...<br/>';  
        $dir = dir(DATA_PATH.$strModulename);
        while($file = $dir->read()) {
	        if(is_file($file)){
	            unlink($file);
	        }
        }
        rmdir(DATA_PATH.$strModulename) or trigger_error("could not delete ".DATA_PATH.$strModulename);
    }    
}

/**
 * Adds an Entry into the Adminmenu if it don't exists.
 */
function addAdminmenu($strModulename, $strOp, $strTitle){
   global $neConfig,$neDb, $neDbWrite, $neTheme;
    /* First Chack if the Module already exists */
    $strQuery  = "SELECT menu_id ";
    $strQuery .= "FROM ".$neConfig['db']['prefix']."_admin_menu ";
    $strQuery .= "WHERE module='$strModulename' AND op='$strOp'";
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if ($result->numRows() == 0){
        $strQuery  = "SELECT menu_id ";
        $strQuery .= "FROM ".$neConfig['db']['prefix']."_admin_menu ";
        $strQuery .= "ORDER BY menu_id DESC LIMIT 1";
        list($intId) = $neDb->getRow($strQuery);
        $intId = ($intId + 1);
        $strQuery  = "INSERT INTO ".$neConfig['db']['prefix']."_admin_menu ";
        $strQuery .= "VALUES('$intId','$strTitle', '$strModulename','$strOp','0')";
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);       
    } else {
        echo 'Menu_entry allready exists';
    }
}

function removeAdminmenu($strModulename, $strOp=''){
   global $neConfig, $neDbWrite, $neTheme;
    /* First Chack if the Module already exists */
    $strQuery = "DELETE FROM ".$neConfig['db']['prefix']."_admin_menu ";
    $strQuery .= "WHERE module='$strModulename' ";
    if ( !empty($strOp)) {
        $strQuery .= "AND op='$strOp'";
    } 
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);       
    echo 'Menu_entry deleted.';
}

/**
 * Sets a Module to active.
 * @param integer Module ID.
 */
function activateModule($intId)
{
    global $neConfig, $neDbWrite, $neTheme;   
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_modules ';
    $strQuery .= "SET active='1' WHERE module_id=$intId";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    header("Location: ".$neConfig['site']['url']."/admin.php?mod=module-admin&op=admin_modules");
}


/**
 * Sets a Module to inactive.
 * @param integer Module ID.
 */
function deactivateModule($intId)
{
    global $neConfig, $neDbWrite, $neTheme;   
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_modules ';
    $strQuery .= "SET active='0' WHERE module_id=$intId";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    header("Location: ".$neConfig['site']['url']."/admin.php?mod=module-admin&op=admin_modules");
}


/**
 * Changes the Access Permissions from the Modules
 */
function changeModulesPermission($arrPermissions)
{
    global $neConfig, $neDbWrite, $neTheme;
    $strModulesTable = $neConfig['db']['prefix'].'_modules';
    foreach($arrPermissions as $intId => $intView) {
    	$intId = (int) $intId;
    	$intView = (int) $intView;
        $strQuery = "UPDATE $strModulesTable SET visible='$intView' ";
        $strQuery.= "WHERE module_id='$intId'";
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);
    }
    header("Location: ".$neConfig['site']['url']."/admin.php?mod=module-admin&amp;op=admin_modules");
}


/**
 * Shows the Readme of a Module.
 */
function showReadme($strModuleName)
{
    global $neTheme;
    $neTheme->drawTitle("$strModuleName : README");
    $message = file("modules/$strModuleName/README");
    echo '<p>';
    foreach ($message as $line) {
    	$line = htmlentities(trim($line));
    	if (empty($line)) {
    		echo '</p><p>';
    	} else {
    		echo $line.'<br/>';
    	}
    	echo '</p>';
    }
    echo "<hr/>";
    echo "<a href=\"admin.php?mod=module-admin&amp;op=admin_modules\">";
    echo " &lt;&lt;".neTranslate('back_to_moduleadmin');
    echo "</a>";
    $neTheme->drawSite();

}

/**
 * 
 */
function showInstallModuleForm()
{
    global $neTheme;
    $neTheme->drawTitle(neTranslate('install_module'));
    ?>
    <form name="install_module" action="admin.php" method="get">
    <input type="hidden" name="mod" value="module-admin" />
    <input type="hidden" name="op" value="install_module" />
    <table class="formtable" align="center">
     <tr>
      <td class="formheader" colspan="2">
       <?php echo neTranslate('install_module') ?>
      </td>
     </tr>
     <tr>
      <th class="formdescr">
       <?php echo neTranslate('name')?>
      </th>
      <td class="formelement">
       <select class="select" name="mod_name">
       <?php
       $modFolder = dir('modules/');
       while ( $modName = $modFolder->read() ) {
           if ( preg_match("/(\.|\/)/",$modName) ) {
               continue;
           } elseif ( file_exists('modules/'.$modName.'/'.$modName.'_setup.php') ) {
               echo '<option>'.$modName.'</option>';
           }
       }
       ?>
       </select>
      </td>
     </tr>
     <tr>
      <td class="formbuttons" colspan="2">
       <button type="submit" class="submit"><?=neTranslate('install_module')?></button>
      </td>
     </tr>
    </table>
    <?php
    $neTheme->drawSite(neTranslate('install_module'));

}

/**
 * A function to edit some Parameter of a Module
 */
function editModule($intId)
{
    global $neConfig, $neDb, $neTheme;
    $neTheme->drawErrorpage('under construction','comming soon');
}

/**
 * the Index Site for the Module Administration
 */
function adminModules()
{
    global $neConfig, $neDb, $neTheme;
    $strModulesTable = $neConfig['db']['prefix'].'_modules';
    $strQuery = "SELECT module_id,name,title,active,visible FROM $strModulesTable";
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    $neTheme->drawTitle('Modules Admin');
    echo '<p class="advice">'.neTranslate('message-admin_modules').'</p><br/>';
    ?>
    <form action="admin.php" method="get">
    <input type="hidden" name="mod" value="module-admin" />
    <input type="hidden" name="op" value="change_modules_perm" />
    <table class="tableview" width="100%">
     <tr class="tableview">
      <th class="tableview"><?php echo neTranslate('icon');?></th>
      <th class="tableview"><?php echo neTranslate('name');?></th>
      <th class="tableview"><?php echo neTranslate('title');?></th>
      <th class="tableview"><?php echo neTranslate('visible');?></th>
      <th class="tableview"><?php echo neTranslate('status');?></th>
      <th class="tableview"><?php echo neTranslate('functions');?></th>
     </tr>
    <?php
    while (list($intId,$strName,$strTitle,$bolActive,$intView) =
    $result->fetchRow() ){
    ?>
     <tr class="tableview">
      <td class="tableview" align="center">
       <?php $neTheme->drawImage($strName,$strTitle,DATA_PATH.'modules/'); ?>
      </td>
      <td class="tableview">
       <?php echo $strName;?>
      </td>
      <td class="tableview" width="25%">
       <?php echo '<a href="index.php?mod='.$strName.'"">'.neTranslate($strTitle).'</a>';?>
      </td>
      <td class="tableview" align="center">
      <?php
    echo '<select class="select" name="view['.$intId.']">';
    if ( $intView == 2 ) {
        echo '<option value="2" selected="selected">';
        echo neTranslate('all_users');
        echo '</option>';
    } else {
            echo '<option value="2">';
            echo neTranslate('all_users');
            echo '</option>';
        }
        if ( $intView == 1 ) {
            echo '<option value="1" selected="selected">';
            echo neTranslate('registed_only');
            echo '</option>';
        } else {
            echo '<option value="1">';
            echo neTranslate('registed_only');
            echo '</option>';
        }
        if ( $intView == 0 ) {
            echo '<option value="0" selected="selected">';
            echo neTranslate('admin_only');
            echo '</option>';
        } else {
            echo '<option value="0">';
            echo neTranslate('admin_only');
            echo '</option>';
        }
        echo '</select>';
        echo "</td>\n";
       echo '<td class="tableview" align="center">';
        if ($bolActive == 1) {
            echo '<a href="admin.php?mod=module-admin&amp;op=deactivate_module&amp;id='.$intId.'">';
            $neTheme->drawImage('ledgreen',neTranslate('active'));
            echo '</a>';
        } else {
            echo '<a href="admin.php?mod=module-admin&amp;op=activate_module&amp;id='.$intId.'">';
            $neTheme->drawImage('ledred',neTranslate('inactive'));
            echo '</a>';
        }
        echo "</td>\n";

        echo '<td class="tableview" align="right">';
        if (file_exists("modules/$strName/README") ) {
            echo "<a href=\"admin.php?mod=module-admin&amp;op=show_readme&amp;mod_name=$strName\">";
            $neTheme->drawImage('readme',neTranslate('show_readme'));
            echo "</a>";
        }

        if (file_exists('modules/'.$strName.'/'.$strName.'_setup.php') ) {
            echo '<a href="admin.php?mod=module-admin&amp;op=install_module&amp;mod_name='.$strName.'">';
            echo '<img src="images/setup.png" alt="[Setup]" border="0">';
            echo "</a>";

            echo '<a href="admin.php?mod=module-admin&amp;op=uninstall_module&amp;mod_name='.$strName.'">';
            echo '<img src="images/delete.png" alt="[Setup]" border="0">';
            echo "</a>";
        }
      /*  echo '<a href="admin.php?mod=module-admin&amp;op=edit_module&amp;id='.$intId.'">';
           $neTheme->drawImage('edit',neTranslate('show_details')); */
         ?>
      </td>
     </tr>
     <?php
    }
    echo '<tr><td colspan="7" class="formbuttons">';
    echo '<button type="button" onclick="location.href=\'admin.php?mod=module-admin&amp;op=install\'">'.neTranslate('install_module').'</button> ';
    echo '<button type="submit">'.neTranslate('change_rights').'</button>';
    echo '</td></tr>';
    echo '</table>';
    echo '</form>';
    $neTheme->DrawSite(neTranslate('Module Admin'));
}
?>