<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This is the News Module for Nuke-Event.
* This File Displays an overview of the Articles
* @package news
* @author $Author: xeniac $
* @version $Revision: 1.6 $
*/
neGetLang($neModuleName);

/**
* load the configuration for the News Module.
*/
require_once ('modules/news/config.php');

/**
* load the common Functions for the News Module.
*/
require_once ('modules/news/news_functions.php');
//==Main Routine================================================================
if (isset($_POST['article_id'])) {
    $intId= (int) $_POST['article_id'];
} elseif (isset($_GET['id'])) {
    $intId= (int) $_GET['id'];
}
if (isset($_GET['topic'])) {
    $intTopic= (int) $_GET['topic'];
} else {
    $intTopic = null;
}
if (MODULE_LOADER == 'admin.php' and empty($neOp)) {
    $neOp= 'admin_news';
}
//administrative operations
if ($neSession->isAdmin($neModuleName)) {
    include_once ('modules/news/admin_functions.php');
    switch ($neOp) {
        case 'activate_article' :
            submitEditArticle($_POST);
            activateArticle($intId);
            neRedirect(MODULE_LOADER."?mod=news&op=admin_news");
            break;
        case 'deactivate_article' :
            submitEditArticle($_POST);
            deactivateArticle($intId);
            neRedirect(MODULE_LOADER."?mod=news&op=admin_news");
            die();
            break;
        case 'delete_article' :
        	if ($_POST['confirm'] == 1) {
            	deleteArticle($intId);
            	neRedirect(MODULE_LOADER.'?mod=news&op=admin_news');           
        	} else {
                showDeleteQuestion($intId);
        	}    
            die();
            break;
        case 'submit_edit' :
            submitEditArticle($_POST);
            neRedirect("admin.php?mod=news&op=admin_news");
            break;
        case 'edit_article' :
            include_once ('modules/news/article_functions.php');
            editArticle($intId);
            break;
        case 'admin_news' :
            adminNews();
            break;
		//Functions for article related hyperlinks
        case 'add_link' :
            include_once ('modules/news/link_functions.php');
            addLink($intId, $_POST['link_name'], $_POST['link_url']);
            die();
            break;
        case 'delete_link' :
            include_once ('modules/news/link_functions.php');
            deleteLink($intId, $_GET['article']);
            break;
        case 'edit_links' :
            include_once ('modules/news/link_functions.php');
            editLinks($intId);
            break;
    }
}
//operations to write new articles
if (($neConfig['news']['allow_user_post'] and $neSession -> isLoggedIn()) OR ($neSession -> isAdmin($neModuleName))) {
    include_once('modules/news/article_functions.php');
    switch ($neOp) {
        case 'preview' :
            previewArticle($_POST);
            break;
        case 'new' :
            include_once('modules/news/article_functions.php');
            newArticle($_POST);
            break;
        case 'submit_add' :
            include_once('modules/news/article_functions.php');
            submitNewArticle($_POST);
            break;
    }
}
//operations to generate RSS Feeds
if ($neConfig['news']['rssfeeds']) {
    switch ($neOp) {
        case 'show_rss' :
            include_once ('modules/news/news_rssfeed.php');
            showRss($intTopic);
            die();
            break;
    }
}
//standard operations (always accessable)
switch ($neOp) {
    case 'show_article' :
        include_once ('modules/news/article_functions.php');
        showArticle($intId);
        break;
    default :
        include ('modules/news/news_index.php');
        displayIndex($intTopic);
        break;
}
?>
