<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with Foobar; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This File Displays is for the List Overview of the Articles
* @package news
* @author $Author: xeniac $
* @version $Revision: 1.8 $
*/

/**
 * Displays a list of the latest News.
 */
function displayIndex($intTopic= NULL,$intPage = 1) {
    global $neConfig, $neDb, $neTheme, $neSession;
    
    //Load the Template File
    $tpl = $neTheme->getTemplate('news','news_index.tpl') or die('x_X');

    /**
     * @var array This array get filled with the ids of the displayed Top
     * Events, so we can prevent duplicate listings.
     */    
    $arrTopArticles = array();
    
    //First we get the Top News....
    $strQueryTop  = 'SELECT news.*,topic_title,topic_id,topic_name,user_name ';
    $strQueryTop .= 'FROM '.$neConfig['db']['prefix'].'_news as news, ';
    $strQueryTop .= $neConfig['db']['prefix']."_topics, ";
    $strQueryTop .= $neConfig['db']['userprefix'].'_users ';
    $strQueryTop .= 'WHERE user_id = article_author ';
    $strQueryTop .= 'AND topic_id = article_topic ';
    $strQueryTop .= 'AND article_waiting = \'0\' ';
    if ($intTopic > 0 ) {
        $strQueryTop .= "AND article_topic = '$intTopic' ";
    }   
    $strQueryTop .="AND article_top='1' ORDER BY article_created DESC LIMIT ".$neConfig['news']['top'];
    $newsTop = $neDb->query($strQueryTop);
    neGetDbError($newsTop,__LINE__,__FILE__,$strQueryTop);
    
    //now we work out all Toparticles
    while ($news = $newsTop->fetchRow(DB_FETCHMODE_ASSOC)) {
        $arrTopArticles[] = $news['article_id'];
        $tpl->setCurrentBlock('top_item');
        $strMorelink = MODULE_LOADER."?mod=news&amp;op=show_article&amp;id=".$news['article_id'];  
        foreach ($news as $key => $value) {
            $tpl->setVariable(strtoupper('TOP_'.$key),$value);
        }
        $tpl->setVariable(array(
            'TOP_ARTICLE_SUMMARY' => neFormatText($news['article_summary']),
            'TOP_ARTICLE_CREATED' => neFormatTimestamp($news['article_created'],'date'),
            'TOP_AUTHOR' => $news['user_name'],
            'TOP_MORE_LINK' => $strMorelink
        ));
        if ($strImage = $neTheme->getImageSrc($news['article_id'].'_big',DATA_PATH.'news/')) { 
             $tpl->setVariable('TOP_BIG_IMAGE',$strImage);
        } else {
             $tpl->setVariable('TOP_BIG_IMAGE', $neTheme->getImageSrc('topics/'.$news['topic_name']));
        }        
        $tpl->parse('top_item');
    }   
    $newsTop->free();

    //now we get the other news....
    $strQuery  = 'SELECT news.*,topic_title,topic_id,topic_name,user_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news as news, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['userprefix'].'_users ';
    $strQuery .= 'WHERE user_id = article_author ';
    $strQuery .= 'AND topic_id = article_topic ';
    $strQuery .= 'AND article_waiting = \'0\' ';
    if ($intTopic > 0 ) {
        $strQuery .= "AND article_topic = '$intTopic' ";
    }   
    $strQuery .='ORDER BY article_created DESC ';
    $intNewsPerPage = $neConfig['news']['actual'] + $neConfig['news']['old'];
    $strQuery .= "LIMIT ".($intPage - 1)*$intNewsPerPage.",$intNewsPerPage";
    
    $newsResult = $neDb->query($strQuery);
    neGetDbError($newsResult,__LINE__,__FILE__,$strQuery);
    //this is our counter
    $i=1;
    
    while($news = $newsResult->fetchRow(DB_FETCHMODE_ASSOC)){
        //when the article was already mentiont as an top article, we skip it.
        if (in_array($news['article_id'],$arrTopArticles)) {
           continue;
        }
        if ($i <= $neConfig['news']['actual'] and $intPage > 1) {
            $strPrefix='NEWS_';
            $tpl->setCurrentBlock('news_item');
        } else {
            $strPrefix='OLD_';
            $tpl->setCurrentBlock('old_item');
        }
        $strMorelink = MODULE_LOADER."?mod=news&amp;op=show_article&amp;id=".$news['article_id'];  
        foreach ($news as $key => $value) {
            $tpl->setVariable(strtoupper($strPrefix.$key),$value);
        }
        $tpl->setVariable(array(
            $strPrefix.'ARTICLE_CREATED' => neFormatTimestamp($news['article_created'],'date'),
            $strPrefix.'AUTHOR' => $news['user_name'],
            $strPrefix.'MORE_LINK' => $strMorelink
        ));
        if ($strImage = $neTheme->getImageSrc($news['article_id'].'_big',DATA_PATH.'news/')) { 
             $tpl->setVariable($strPrefix.'BIG_IMAGE',$strImage);
        } else {
             $tpl->setVariable($strPrefix.'BIG_IMAGE', $neTheme->getImageSrc('topics/'.$news['topic_name']));
        }        
        if ($strImage = $neTheme->getImageSrc($news['article_id'].'_small',DATA_PATH.'news/')) { 
             $tpl->setVariable($strPrefix.'SMALL_IMAGE',$strImage);
        } else {
             $tpl->setVariable($strPrefix.'SMALL_IMAGE', $neTheme->getImageSrc('topics/'.$news['topic_name']));
        }        
        if ($neSession->isAdmin('news') ) {
            $tpl->setVariable(array(
            'DELETE_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=delete_article&amp;id='.$news['article_id'].'">'.$neTheme->getImage('delete',neTranslate('delete')).'</a>',
            'EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=edit_article&amp;id='.$news['article_id'].'">'.
            $neTheme->getImage('edit',neTranslate('edit')).'</a> ',
            'EDIT_LINKS_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=edit_links&amp;id='.$news['article_id'].'">'.$neTheme->getImage('link',neTranslate('edit_links')).'</a> '
            ));
        }   
        $tpl->parseCurrentBlock();
        $i++;
	 }	
    $newsResult->free();
 
	//Show the Admin Functions:
    if ($neSession->isAdmin('news') ) {
	    $strQuery  = 'SELECT article_id ';
		$strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news ';
		$strQuery .= 'WHERE article_waiting=1';
		$result = $neDb->query($strQuery);
		neGetDbError($result,__LINE__,__FILE__,$strQuery);
		$numWaiting = $result->numRows();
        $tpl->setCurrentBlock('admin');
        $tpl->setVariable(array(
		    'LABEL_ARTICLES_WAITING' => neTranslate('articles_waiting'),
			'ARTICLES_WAITING' => '<a href="admin.php?mod=news">'
                                  .$numWaiting.'</a>',
			'NEW_ARTICLE' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=new">'
			                 .neTranslate('new_article').'</a>'
		));
	}
    $tpl->show();
    $neTheme->drawSite(neTranslate('news'));
}
?>
