<?php

function showRss($intTopicId) {
    global $neConfig, $neDb, $neTheme, $neSession;
    header('Content-Type: application/xml');

    /*Load the Template File*/
    $tpl = $neTheme->getTemplate('news','rss_feed.tpl') or die('x_X');

    /*Build the SQL Query */
    $strQuery  = 'SELECT news.*, topics.*, users.* ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news news, ';
    $strQuery .= $neConfig['db']['prefix']."_topics topics, ";
    $strQuery .= $neConfig['db']['userprefix'].'_users users ';
    $strQuery .= 'WHERE users.user_id = news.article_author ';
    $strQuery .= 'AND topics.topic_id = news.article_topic ';
    $strQuery .= 'AND news.article_waiting = \'0\' ';
    if ($intTopic > 0 ) {
        $strQuery .= "AND news.topic = '$intTopic' ";
    }
    $strQuery .='ORDER BY news.article_id DESC ';
    $strQuery .= 'LIMIT '.$neConfig['news']['rss'];
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);

    $tpl->setCurrentBlock('newsitem');
    $tpl->setVariable(array(
        'HOMEPAGE_TITLE' => $neConfig['backend']['title'],
        'HOMEPAGE_LANGUAGE' => $neConfig['backend']['language'],
        'HOMEPAGE_DESCRIPTION' => $neConfig['meta']['description'],
        'HOMEPAGE_IMAGE' => $neConfig['backend']['image'],
        'HOMEPAGE_URL' => $neConfig['site']['url']
    ));
    while ($item = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
        $strMorelink = "index.php?mod=news&amp;op=show_article&amp;id=".$item['article_id'];  
        $tpl->setVariable(array(
            'TITLE' => htmlspecialchars($item['article_title']),
            'AUTHOR' => $item['username'],
            'CREATED' => date('r',strtotime($item['article_created'])),
            'TOPIC_TITLE' => $item['topic_title'],
            'TOPIC_ID' => $item['topic_id'],
            'ABSTRACT' => htmlspecialchars($item['article_summary']),
            'MORE_LINK' => $neConfig['site']['url']."/$strMorelink",
	));
        if ($strImage = $neTheme->getImageSrc('news/'.$news['article_id'].'_small',DATA_PATH)) { 
             $tpl->setVariable('IMAGE',$strImage);
	    } else {
	        $tpl->setVariable('IMAGE', $neTheme->getImageSrc('topics/'.$news['topic_name']));
        }
        $tpl->parse('newsitem');
    }
    $tpl->show();
    ob_end_flush();
    $result->free();
}
?>
