<?php
/**
* The Setuproutine for the Topics Module:
*
* @package nukeevent.modules.topics
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
* Installs News
*/
function install()
{
    global $neDb, $neDbWrite, $neConfig;
    //Create the Newsarticle Table
    $strQuery  = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_news (';
    $strQuery .= 'article_id int(20) unsigned NOT NULL,';
    $strQuery .= 'article_author int(20) unsigned NOT NULL,';
    $strQuery .= 'article_topic int(10) unsigned NOT NULL,';
    $strQuery .= 'article_title varchar(255) NOT NULL,';
    $strQuery .= 'article_summary text NOT NULL,';
    $strQuery .= 'article_detail text,';
    $strQuery .= 'article_created datetime NOT NULL,';
    $strQuery .= 'article_waiting int(1) NOT NULL default \'1\',';
    $strQuery .= 'article_top int(1) NOT NULL default \'1\',';
    $strQuery .= 'PRIMARY KEY  (article_id)';
    $strQuery .= ')';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);
    
    //Create the Links Table
    $strQuery = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_news_links (
                 link_id int(3) NOT NULL default \'0\',
                 article_id int(3) NOT NULL default \'0\',
                 link_title varchar(80) NOT NULL default \'\',
                 link_url varchar(80) NOT NULL default \'\',
                 PRIMARY KEY  (`link_id`)
    ) ';
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);

    //Create the Comments Table
    $strQuery = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_news_comments (
                 comment_id int(20) NOT NULL,
                 thread_id int(20) NOT NULL,
                 comment_poster int(20) NOT NULL,
                 comment_title varchar(80) NOT NULL default \'\',
                 comment_text text,
                 comment_reply int(20) NOT NULL,
                 PRIMARY KEY  (`thread_id`)
    ) ';
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);

    addModule('news','News');
    addAdminmenu('news','admin_news','Admin News');
    addAdminmenu('news','new','Write Article');
}

/**
* uninstalls the module
*/
function uninstall()
{
    global $neDb, $neDbWrite, $neConfig;
    removeModule('news','News');
    removeAdminmenu('news');
    //drop the News Table
    $strQuery  = 'DROP TABLE IF EXISTS '.$neConfig['db']['prefix'].'_news';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery); 
    
    //drop the Links Table
    $strQuery  = 'DROP TABLE IF EXISTS '.$neConfig['db']['prefix'].'_news_links';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery); 
  
    //drop the Comments Table
    $strQuery  = 'DROP TABLE IF EXISTS '.$neConfig['db']['prefix'].'_news_comments';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery); 
}

switch ($neOp){
    case 'install_module':
        install();
        $neTheme->drawSite();
        break;
    case 'uninstall_module':
        uninstall();
        $neTheme->drawSite();
        break;
}
?>
