<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* a module to administrate html pages in NukeEvent.
*
* @package nukeevent.modules.wiki
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

//load the Language File for the Wiki Module
neGetLang('wiki');
require_once('modules/wiki/wiki_functions.php');

if (isset($_POST['name'])) {
    $strName = neCheckText($_POST['name'],'plain');
} elseif (isset($_GET['name'])) {
    $strName = neCheckText($_GET['name'],'plain');
} else {
   $strName = 'index';
}

if (isset($_POST['title'])) {
    $strTitle = neCheckText($_POST['title'],'plain');
} else {
    $strTitle = null;
}

if (isset($_POST['content'])) {
    $strContent = neCheckText($_POST['content'],'wiki');
} else {
    $strContent = null;
}

if (isset($_POST['visible'])) {
    $intVisible = (int) $_POST['visible'];
} else {
    $intVisible = 0;
}

if (isset($_POST['editable'])) {
    $intEditable = (int) $_POST['editable'];
} else {
    $intEditable = 0;
}

if (isset($_GET['is_confirmed']) AND $_GET['is_confirmed'] == 1) {
    $bolConfirmed = true;
} else {
    $bolConfirmed = false;
}

if (MODULE_LOADER == 'admin.php' and empty($neOp)){
    $neOp='admin_wiki';
}

//check for adminisrative tasks
if ( $neSession->IsAdmin($neModuleName)) {
    switch ($neOp) {
    case 'delete':
        require_once('modules/content/admin_functions.php');
        deletePage($strName,$bolConfirmed);
        die();
        break;
    case 'add':
        require_once('modules/content/admin_functions.php');
        addPage();
        die();
        break;
     case 'export':
        require_once('modules/content/admin_functions.php');
        exportPage($strName);
        die();
        break;
     case 'admin_content':
        require_once('modules/wiki/admin_functions.php');
        adminContent();
        die();
        break;
     }
}

switch ($neOp) {
case 'edit':
    require_once('modules/wiki/edit_functions.php');
    editPage($strName);
    die();
    break;
case 'submit':
    require_once('modules/wiki/edit_functions.php');
    submitPage($strName,$strTitle,$strContent,$intVisible,$intEditable);
    neRedirect(MODULE_LOADER.'?mod=wiki&op=show&name='.urlencode($strName));
    die();
    break;
default:
    displayContent($strName);
    break;
}
?>
