<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Functions commonly used by the WIKI Module 
*
* @package nukeevent.modules.wiki
* @author $Author: xeniac $
* @version $Revision: 1.1 $
*/

function getEditLink($strName) {
    global $neTheme;
    $strReturn = '<a href="'.MODULE_LOADER.'?mod=wiki&amp;op=edit&amp;';
    $strReturn .= 'name='.urlencode($strName).'">';
    $strReturn .= $neTheme->getImage('edit',neTranslate('edit'));
    $strReturn .= '</a>';
    return($strReturn);
}

function getExportLink($strName) {
    global $neTheme;
    $strReturn = '<a href="'.MODULE_LOADER.'?mod=wiki&amp;op=export&amp;';
    $strReturn .= 'name='.urlencode($strName).'">';
    $strReturn .= $neTheme->getImage('save',neTranslate('export'));
    $strReturn .= '</a> ';
    return($strReturn);
}

function getDeleteLink($strName) {
    global $neTheme;
    $strJScript  = "return confirmBox(this,'";
    $strJScript .= "$strName\\n".neTranslate('text-delete_page');
    $strJScript .= "')";

    $strReturn = '<a onclick="'.$strJScript.'" href="'.MODULE_LOADER.'?mod=wiki&amp;op=delete&amp;';
    $strReturn .= 'name='.urlencode($strName).'" onclick".$strJScript.">';
    $strReturn .= $neTheme->getImage('delete',neTranslate('delete'));
    $strReturn .= '</a> ';
    return($strReturn);
}

/**
* Displays the Site.
*/
function getContent($strName)
{
    global $neConfig, $neSession, $neDb, $neTheme;
    $strQuery  = 'SELECT content, editable, readable ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name='$strName' " ;
    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__,$strQuery);
    if ($page['active'] == 1 or $neSession->isAdmin('content')){
        $strReturn = neFormatText($page['content'],'wiki');
    } else {
        $strReturn = '';
    }
    if ($neSession->isAdmin('content')){
        $strReturn .= '<div style="text-align:right">';
        $strReturn .= getExportLink($strName);
        $strReturn .= getEditLink($strName);
        $strReturn .= '</div>';
    }
    return $strReturn;
}

function displayContent($strName=index)
{
    global $neConfig, $neSession, $neDb, $neTheme;
    $strQuery  = 'SELECT * FROM ';
    $strQuery .=  $neConfig['db']['prefix'].'_wiki ';
    $strQuery .= 'WHERE page_name='.$neDb->quote($strName) ;
    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__,$strQuery);

    /*when the User have enought rights to view the page,
     * we could start to render the whole thing.
     */ 
    if ($neSession->getPermission('content') <= $page['visible'] ){
        //Get all known wikipages        
        $arrPages = $neDb->getCol('SELECT page_name FROM '.$neConfig['db']['prefix'].'_wiki');
        neGetDbError($arrPages,__LINE__,__FILE__,$strQuery);

        //initialize the Wiki Engine
        require_once 'Text/Wiki.php';
        $wiki = new Text_Wiki();
        $wiki->setRenderConf('xhtml','wikilink','view_url','index.php?mod=wiki&amp;op=view&amp;name=');
        $wiki->setRenderConf('xhtml','wikilink','new_url','index.php?mod=wiki&amp;op=edit&amp;name=');
        $wiki->setRenderConf('xhtml','wikilink','pages', $arrPages);
        $wiki->setRenderConf('xhtml','freelink','view_url','index.php?mod=wiki&amp;op=view&amp;name=');
        $wiki->setRenderConf('xhtml','freelink','new_url','index.php?mod=wiki&amp;op=edit&amp;name=');
        $wiki->setRenderConf('xhtml','freelink','pages', $arrPages);
        
              
        $tpl = $neTheme->getTemplate('content','content.tpl');
        $tpl->setVariable(array(
            'LABEL_CHANGED' => neTranslate('changed'),
            'TITLE' => $page['title'],
            'AUTHOR' => neGetUserName($page['author']),
            'CHANGED' => neFormatText($page['changed']),
            'CONTENT' => $wiki->transform($page['content'],'Xhtml')            
        ));
        if ($neSession->getPermission('content') <= $page['visible'] ){
        	$tpl->setVariable('EDIT_LINK',getEditLink($strName));
        }    
        if ($neSession->isAdmin('content')){
            $tpl->setVariable(array(
                'EXPORT_LINK' => getExportLink($strName),
                'DELETE_LINK' => getDeleteLink($strName)
            ));
        }
        $tpl->parse();
        $tpl->show();
    } else {
        $neTheme->drawErrorPage(
            neTranslate('inactive_page'),
            neTranslate('text-inactive_page')
        );
    }
    $neTheme->drawSite(neFormatText($page['title']));
}
