<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This module administrates and shows Yellow Pages.
*
* @package nukeevent.modules.shopdir
* @author Christian Berg
* @version $Revision: 1.1 $
*/

/**
* Draw all Topics.
* Searches all active Topics from the Database and creates a Site 
* to display them.
*/
function drawShopdir() {
    global $neConfig, $neDb, $neTheme;
    $tpl= $neTheme->getTemplate('yellowpages', 'show_yellowpages.tpl');
    $tpl->setVariable(array(
    'MOD'   => 'yellowpages',
    'op'   => 'view',
    'LABEL_SEARCH'   => neTranslate('search'),
    'LABEL_SEARCH'   => neTranslate('search'),
    'LABEL_COUNTRY'  => neTranslate('country'),
    'LABEL_CATEGORY' => neTranslate('category'),
    'OPTIONS_COUNTRY'  => getOptionsCountry($arrSearchForm['country']),
    'OPTIONS_CATEGORY' => getOptionsCategory($arrSearchForm['category']),
    ));

    //Query the Shop Database
    $strQuery  = "SELECT * ";
    $strQuery .= "FROM ".$neConfig['db']['prefix']."_shopdir_shops ";
    $strQuery .= "ORDER BY shop_name";
    $result = $neDb->query($strQuery);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);
    if ($result->numRows() > 0) {
        $intTd = 1;
        $tpl->setCurrentBlock('shop');
        while ($shop = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
            $tpl->setVariable(array(
            'SHOP_NAME' => $shop['shop_name'],
            'SHOP_STREET' => $shop['shop_street'],
            'SHOP_POSTCODE' => $shop['shop_postcode'],
            'SHOP_EMAIL' => '<a href="mailto:'.$shop['shop_email'].'">'.$shop['shop_email'].'</a>',
            ));
            $tpl->parse('shop');
            if ($intTd >= $neConfig['yellowpages']['cols']) {
                $tpl->parse('shoprow');
                $intTd = 1;
            } else {
                $intTd++;
            }
        }
    }
    $tpl->show();
    $neTheme -> drawSite(neTranslate('active_topics'));
}
?>
