<?php
function createUsers() {
    global $neDbWrite,$neConfig;   
    $strQuery  = "CREATE TABLE IF NOT EXISTS `".$neConfig['db']['userprefix']."_users` (
    `user_id` int(10) NOT NULL default '0',
    `user_name` char(64) NOT NULL default '',
    `user_admin` int(1) NOT NULL default '0',
    `user_superuser` int(1) NOT NULL default '0',
    `user_email` char(255),
    `user_theme` char(64),
    `user_lang` char(2),
    `user_points` int(16) NOT NULL default '0',
    `user_password` char(80) NOT NULL default '',
    `user_last_login` timestamp,
    `user_cookie` char(255) NOT NULL default '',
    `user_session` char(255) NOT NULL default '',
    `user_ip` char(15) NOT NULL default '127.0.0.1',
    PRIMARY KEY (`user_id`),
    UNIQUE KEY `name` (`user_name`)
)";
    $result = $neDbWrite->query($strQuery);
    getDbError($result,__LINE__,__FILE__,$strQuery);
}

function createBlocks() {
    global $neDbWrite, $neConfig;   
    $strQuery  = "CREATE TABLE IF NOT EXISTS `".$neConfig['db']['prefix']."_blocks` (
  	`block_id` int(12) NOT NULL default '0',
  	`title` varchar(255) NOT NULL default '',
  	`weight` int(3) NOT NULL default '0',
  	`language` char(2) default NULL,
  	`visible` int(1) NOT NULL default '0',
  	`active` int(1) NOT NULL default '0',
  	`position` int(1) NOT NULL default '0',
  	`module` varchar(255) NOT NULL default 'ALL',
  	`block_type` int(1) NOT NULL default '0',
  	`url` varchar(255) default NULL,
  	`blockfile` varchar(32) default NULL,
  	`content` text,
  	PRIMARY KEY (`block_id`)
	)";
    $result = $neDbWrite->query($strQuery);
    getDbError($result,__LINE__,__FILE__,$strQuery);
}
function createAdminMenu() {
    global $neDbWrite,$neConfig;   
    $strQuery  = "CREATE TABLE IF NOT EXISTS `".$neConfig['db']['prefix']."_admin_menu` (
	`menu_id` int(12) NOT NULL default '0',
 	`text` char(64) NOT NULL default '',
 	`module` char(64) NOT NULL default '',
	`op` char(64) NOT NULL default '',
 	`weight` int(3) NOT NULL default '0',
  	PRIMARY KEY  (`menu_id`)
	)";
    $result = $neDbWrite->query($strQuery);
    getDbError($result,__LINE__,__FILE__,$strQuery);
}
function createAdminPermissions() {
    global $neDbWrite,$neConfig;   
    $strQuery  = "CREATE TABLE IF NOT EXISTS `".$neConfig['db']['prefix']."_admin_permissons` (
  	`user_id` int(12) NOT NULL default '0',
  	`module_name` char(80) NOT NULL default '',
	PRIMARY KEY  (`user_id`,`module_name`)
	)";
    $result = $neDbWrite->query($strQuery);
    getDbError($result,__LINE__,__FILE__,$strQuery);
}
function createModules() {
    global $neDbWrite,$neConfig;   
    $strQuery  = "CREATE TABLE IF NOT EXISTS `".$neConfig['db']['prefix']."_modules` (
 	`module_id` int(4) NOT NULL default '0',
  	`name` char(25) NOT NULL default '',
  	`visible` tinyint(2) NOT NULL default '0',
  	`active` tinyint(1) NOT NULL default '0',
  	`title` char(64) NOT NULL default '',
  	PRIMARY KEY  (`module_id`),
  	UNIQUE KEY `name` (`name`)
	)";
    $result = $neDbWrite->query($strQuery);
    getDbError($result,__LINE__,__FILE__,$strQuery);
}

function createTables() {
	global $neDb;
    $strQuery = 'SHOW TABLES';
    $arrTables = $neDb->getAll($strQuery);
    getDbError($arrTables,__LINE__,__FILE__,$strQuery);
    createUsers();
    createBlocks();
    createAdminMenu();
    createAdminPermissions();
	createModules();
	return true;
}

function createAdmin() {
	global $neConfig, $neDb, $neDbWrite;
    $strQuery = 'SELECT user_id FROM '.$neConfig['db']['userprefix'].'_users';
    $result = $neDb->query($strQuery);
    if ($result->numRows() == 0) {
    	$strQuery = 'INSERT INTO '.$neConfig['db']['userprefix'].'_users (';
    	$strQuery .= 'user_id, user_name, user_admin, user_superuser, user_email, user_password';
    	$strQuery .= ') VALUES (';
    	$strQuery .= "'1', ";		
    	$strQuery .= "'admin', ";		
    	$strQuery .= "'1', ";		
    	$strQuery .= "'1', ";		
    	$strQuery .= "'root@localhost', ";		
    	$strQuery .= "MD5('root')";		
    	$strQuery .= ')';
    	$result = $neDbWrite->query($strQuery);
        getDbError($result,__LINE__,__FILE__,$strQuery);
    }
	return true;
}

?>