# Create tables for PHP-Nuke Webpages module
#
# User web page module tables
#
# User web page table

drop table if exists nuke_webpages;
create table nuke_webpages (
  uid int(11) NOT NULL,
  title TEXT NOT NULL,
  webpage TEXT NOT NULL,
  showname int(1) NOT NULL DEFAULT '1',
  fullpage int(1) NOT NULL DEFAULT '0',
  enable int(1) NOT NULL DEFAULT '1',
  format int(2) NOT NULL DEFAULT '0',
  primary key(uid)
) TYPE=MyISAM;

insert nuke_webpages set uid=-1;


# Group web page table

drop table if exists nuke_webpagegroups;
create table nuke_webpagegroups (
  guid int(11) NOT NULL auto_increment,
  adminuid int(11) NOT NULL DEFAULT '-1',
  locked int(1) NOT NULL DEFAULT '0',
  groupname TEXT NOT NULL,
  webpage TEXT NOT NULL ,
  showname int(1) NOT NULL DEFAULT '1',
  fullpage int(1) NOT NULL DEFAULT '0',
  format int(2) NOT NULL DEFAULT '0',
  primary key(guid)
) TYPE=MyISAM;

insert nuke_webpagegroups set groupname='User Web Pages';

# Group/user cross reference table

drop table if exists nuke_webusergroup;
create table nuke_webusergroup (
  id int(11) NOT NULL auto_increment,
  guid int(11) NOT NULL,
  uid int(11) NOT NULL,
  primary key(id)
) TYPE=MyISAM;

# Image cross reference table

drop table if exists nuke_webimages;
create table nuke_webimages (
  id int(11) NOT NULL auto_increment,
  uid int(11) NOT NULL,
  imagetype TEXT NOT NULL,
  primary key(id)
) TYPE=MyISAM;



