#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -Z 1:2-4 -Z 2:2-4 -f 183 report1 report4 > ./output/Zf183G2_4rep1rep4
$NUMDIFF -z 1:@ -z 2:@ -f 0 report1 report2 > ./output/f0rep1rep2
$NUMDIFF -z 1:@ -z 2:@ -f 0 report1 report3 > ./output/f0rep1rep3
$NUMDIFF -z 1:@ -z 2:@ -f 183 report1 report4 > ./output/f183rep1rep4
$NUMDIFF -z 1:@ -z 2:@ -f -1 report3 report1 > ./output/f_1rep3rep1
$NUMDIFF -z 1:@ -z 2:@ -N report1 report_even > ./output/zNrep1rep_ev
$NUMDIFF -z 1:@ -z 2:@ -P report1 report_even > ./output/zPrep1rep_ev
$NUMDIFF -z 1:@ -z 2:@ -V -X 1:4 -X 2:4 report4 report1 > ./output/zVF1_3rep4rep1
$NUMDIFF -z 1:@ -z 2:@ -V report4 report1 > ./output/zVrep4rep1
$NUMDIFF -z 1:@ -z 2:@ -b -V report4 report1 > ./output/zbVrep4rep1
$NUMDIFF -z 1:@ -z 2:@ -f 170 report_even report1 > ./output/zf170rep_evrep1
$NUMDIFF -z 1:@ -z 2:@ -f -165 report_odd report1 > ./output/zf_165rep_odrep1 
$NUMDIFF -z 1:@ -z 2:@ report1 report_even > ./output/zrep1rep_ev
$NUMDIFF -z 1:@ -z 2:@ report_odd report1 > ./output/zrep_odrep1 

LIST="Zf183G2_4rep1rep4 f0rep1rep2 f0rep1rep3 f183rep1rep4 f_1rep3rep1 zNrep1rep_ev zPrep1rep_ev zVF1_3rep4rep1 zVrep4rep1 zbVrep4rep1 zf170rep_evrep1 zf_165rep_odrep1 zrep1rep_ev zrep_odrep1"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

# Common error message
# ***  End of file "file1" reached
#      Likely the files "file1" and "file2" do not have the same number of lines !
