#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -z 1:@ -z 2:@ -I -f0 test16.1 test16.2 > ./output/zIf0
$NUMDIFF -z 1:@ -z 2:@ -I -V test16.1 test16.2   > ./output/zIV
$NUMDIFF -Z 1:3- -Z 2:3- -f0 test16.1 test16.2  > ./output/Z3_ENDf0
$NUMDIFF -Z 1:3- -Z 2:3- -V test16.1 test16.2    > ./output/Z3_ENDV
$NUMDIFF -Z 1:3- -Z 2:3- -V -E test16.1 test16.2 > ./output/Z3_ENDVE
$NUMDIFF -Z 1:3- -Z 2:3- -X 1:7 -X 2:7 -V test16.1 test16.2   > ./output/Z3_ENDX7V
$NUMDIFF -X 1:7 -X 2:7 -Z 1:3- -Z 2:3- -V test16.1 test16.2   > ./output/X7Z3_ENDV
$NUMDIFF -z 1:3- -z 2:3- -Z 1:3- -Z 2:3- -V test16.1 test16.2 > ./output/zZ3_ENDV
$NUMDIFF -Z 1:3- -Z 2:3- -z 1:3- -z 2:3- -V test16.1 test16.2 > ./output/Zz3_ENDV
$NUMDIFF -z 1:@ -z 2:@ -I -f180 test16.1 test16.3               > ./output/zIf180test16.1.3
$NUMDIFF -z 1:@ -z 2:@ -I -X 1:8 -X 2:8 -f180 test16.1 test16.3 > ./output/zIX8f180test16.1.3
$NUMDIFF -X 1:8 -X 2:8 -z 1:@ -z 2:@ -I -f180 test16.1 test16.3 > ./output/X8zIf180test16.1.3
$NUMDIFF -Z 1:3- -Z 2:3- -f180 test16.1 test16.3                > ./output/Z3_f180test16.1.3
$NUMDIFF -X 1:8 -X 2:8 -Z 1:3- -Z 2:3- -f180 test16.1 test16.3  > ./output/X8Z3_f180test16.1.3
$NUMDIFF -Z 1:3- -Z 2:3- -X 1:8 -X 2:8 -f180 test16.1 test16.3  > ./output/Z3_X8f180test16.1.3

LIST="zIf0 zIV Z3_ENDf0 Z3_ENDV Z3_ENDVE Zz3_ENDV zZ3_ENDV X7Z3_ENDV Z3_ENDX7V zIf180test16.1.3 zIX8f180test16.1.3 X8zIf180test16.1.3 Z3_f180test16.1.3 X8Z3_f180test16.1.3 Z3_X8f180test16.1.3"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

