#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2010    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3
CC=cc
TIME=/usr/bin/time
ERONE=./erone
ERONE_C=./erone.c
N1=50000
N2=500000

# First step: build erone
$CC $ERONE_C -o $ERONE -lm
# Second step: generate text files for testing
$ERONE $N1 > exact25S  2> approx25S
sed -f sedprog1  exact25S > exact250S
sed -f sedprog2 approx25S > approx250S
sed -f sedprog3  exact25S > exact5000S
sed -f sedprog4 approx25S > approx5000S
$ERONE $N2 >  exact25L 2> approx25L
sed -f sedprog1  exact25L > exact250L
sed -f sedprog2 approx25L > approx250L
sed -f sedprog3  exact25L > exact5000L
sed -f sedprog4 approx25L > approx5000L
# Last step: run Numdiff to measure the execution time
echo "** Test of $NUMDIFF with $N1 input lines **"
echo "Input numbers with exponent +/-25"
echo "Filter only:"
$TIME $NUMDIFF  -o minortest25S  -z 1-2 -f exact25S approx25S
echo -e "\nFilter and compare with verbose output:"
$TIME $NUMDIFF  -o majortest25S  -z 1-2 -V exact25S approx25S
echo -e "\nInput numbers with exponent +/-250"
echo "Filter only:"
$TIME $NUMDIFF  -o minortest250S  -z 1-2 -f exact250S approx250S
echo -e "\nFilter and compare with verbose output:"
$TIME $NUMDIFF  -o majortest250S  -z 1-2 -V exact250S approx250S
echo -e "\nInput numbers with exponent +/-5000"
echo "Filter only:"
$TIME $NUMDIFF  -o minortest5000S -z 1-2 -f exact5000S approx5000S
echo -e "\nFilter and compare with verbose output:"
$TIME $NUMDIFF  -o majortest5000S -z 1-2 -V exact5000S approx5000S
# 
# 
echo -e "\n\n** Test of $NUMDIFF with $N2 input lines **"
echo -e "Input numbers with exponent +/-25\n"
echo "Filter only:"
$TIME $NUMDIFF  -o minortest25L -z 1-2 -f exact25L approx25L
echo -e "\nFilter and compare with verbose output:"
$TIME $NUMDIFF  -o majortest25L -z 1-2 -V exact25L approx25L
echo -e "\nInput numbers with exponent +/-250"
echo "Filter only:"
$TIME $NUMDIFF  -o minortest250L  -z 1-2 -f exact250L approx250L
echo -e "\nFilter and compare with verbose output:"
$TIME $NUMDIFF  -o majortest250L  -z 1-2 -V exact250L approx250L
# echo -e "\nInput numbers with exponent +/-5000"
# echo "Filter only:"
# $TIME $NUMDIFF  -o minortest5000L -z 1-2 -f exact5000L approx5000L
# echo -e "\nFilter and compare with verbose output:"
# $TIME $NUMDIFF  -o majortest5000L -z 1-2 -V exact5000L approx5000L
#
#
echo "Removing output files..."
rm ./exact* ./approx*
rm ./minortest* ./majortest*
rm $ERONE
echo "Done !"
