#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -X 2:1 -Z 1:2- -Z 2:3- -f  Table1 Table2 > ./output/X2:1Z1:2-Z2:3-
$NUMDIFF -X 2:1 -Z 1:1 -Z 2:2 -Z 1:3- -Z 2:4- -f  Table1 Table2 > ./output/X2:1Z1:1Z2:2Z1:3-Z2:4-
$NUMDIFF -X 2:1 -Z 1:1-3 -Z 2:2-4 -Z 1:5- -Z 2:6- -f  Table1 Table2 > ./output/X2:1Z1:1-3Z2:2-4Z1:5-Z2:6-
$NUMDIFF -X 2:1 -Z 1:-3 -Z 2:2-4 -Z 1:5- -Z 2:6- -f  Table1 Table2 > ./output/X2:1Z1:-3Z2:2-4Z1:5-Z2:6-
$NUMDIFF -X 2:1-4 -X 1:1-3 -Z 1:5- -Z 2:6- -f  Table1 Table2 > ./output/X2:1-4X1:1-3Z1:5-Z2:6-
$NUMDIFF -X 2:1-4 -X 1:1-3 -z 1:5- -z 2:6- -f  Table1 Table2 > ./output/X2:1-4X1:1-3z1:5-z2:6-
$NUMDIFF -X 2:1 -z 1:1 -Z 1:2- -z 2:2 -Z 2:3- -f  Table1 Table2 > ./output/X2:1z1:1Z1:2-z2:2Z2:3-
$NUMDIFF -X 2:1 -z 1:1-2 -Z 1:3- -z 2:2-3 -Z 2:4- -f  Table1 Table2 > ./output/X2:1z1:1-2Z1:3-z2:2-3Z2:4-
$NUMDIFF -X 2:1 -z 1:-2 -Z 1:3- -z 2:2-3 -Z 2:4- -f  Table1 Table2 > ./output/X2:1z1:-2Z1:3-z2:2-3Z2:4-
$NUMDIFF -X 1:1 -z 2:-2 -Z 2:3- -z 1:2-3 -Z 1:4- -f  Table2 Table1 > ./output/X1:1z2:-2Z2:3-z1:2-3Z1:4-
$NUMDIFF -X 1:1 -Z 2:-3 -Z 1:2-4 -Z 2:5- -Z 1:6- -f  Table2 Table1 > ./output/X1:1Z2:-3Z1:2-4Z2:5-Z1:6-

LIST="X1:1Z2:-3Z1:2-4Z2:5-Z1:6- X1:1z2:-2Z2:3-z1:2-3Z1:4- X2:1-4X1:1-3Z1:5-Z2:6- X2:1-4X1:1-3z1:5-z2:6- X2:1Z1:-3Z2:2-4Z1:5-Z2:6- X2:1Z1:1-3Z2:2-4Z1:5-Z2:6- X2:1Z1:1Z2:2Z1:3-Z2:4- X2:1Z1:2-Z2:3- X2:1z1:-2Z1:3-z2:2-3Z2:4- X2:1z1:1-2Z1:3-z2:2-3Z2:4- X2:1z1:1Z1:2-z2:2Z2:3-"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
