/*
    Copyright (C)  2005,2006,2007,2008,2009,2010,2011,2012,2013  Ivano Primi  <ivprimi@libero.it>    
  
    Copying and distribution of this file, with or without modification,
    are permitted in any medium without royalty provided the copyright
    notice and this notice are preserved.
*/

#include<stdio.h>
#include<math.h>

#define MULTIPLIER1 1.0e25
#define MULTIPLIER2 1.0e-25
#define DEF_N       100
#define MAX_N       1000000

double approx_sqrt(double x, unsigned n)
{
  double root;

  if ( x <= 0.0 )
    return 0.0;
  else
    {
      for (root = x * 0.5; n > 0; n--)
	{
	  root = 0.5 * (root + x/root);
#ifdef DEBUG
	  fprintf(stderr, "<%e>\n", root);
#endif
	}
      return root;
    }
}

int main (int argc, char** argv)
{
  unsigned long i, N;
  const unsigned int n = 5;

  /*   This program prints on stdout "i  sqrt(i) * MULTIPLIER1" */
  /*   and "i  approx_sqrt(i) * MULTIPLIER2" on stderr          */
  /*   for every i = 1, ..., N with N given.                    */
  if (argc == 1)
    N = DEF_N;
  else
    {
      N = strtoul (argv[1], NULL, 10);
      if (N == 0 || N > MAX_N)
	N = DEF_N;
    }
  puts ("************************************************************");
  printf ("                   N    SQRT(N) * %g\n", MULTIPLIER1);
  puts ("------------------------------------------------------------");
  for (i = 1; i <= N; i++)
    {
      fprintf (stdout, "%20lu  %.12e\n", i, sqrt((double)i)*MULTIPLIER1);
      fprintf (stderr, "%20lu  %.12e\n", i, approx_sqrt((double)i, n)*MULTIPLIER2);      
    }
  return 0;
}
