#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NDSELECT=$4

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -b 4 -e 15 -s 3 ndselect_test > ./output/b4e15s3.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -F 2 -L 4 ndselect_test > ./output/F2L4.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -O '\t' -F 2 -L 4 ndselect_test > ./output/F2L4Otab.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -O '\t\t' ndselect_test > ./output/Otabtab.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -O '\t\t' -x ndselect_test > ./output/xOtabtab.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -b 4 -e 15 -s 3 -F 2 -L 8 -I 2 ndselect_test > ./output/b4e15s3F2L8I2.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -b 4 -e 15 -s 3 -F 2 -L 8 -I 2 -O '\t' ndselect_test > ./output/b4e15s3F2L8I2Otab.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -F 4 -I 3 -b 6 -s 2 ndselect_test > ./output/F4I3b6s2.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -F 4 -I 3 -b 6 -s 2 -O '\t' ndselect_test > ./output/F4I3b6s2Otab.res

$NDSELECT -D '\s \t \n \" !! .$ -\xE2\x82\xAC :::: :: #\xE2\x82\xAC ### **** |' -x -F 4 -I 3 -b 6 -s 2 -O '\t' ndselect_test > ./output/xF4I3b6s2Otab.res

$NDSELECT -S ' \t\n$\"\041|:\x23' -e 18 ndselect_test > ./output/e18.res 

$NDSELECT -S ' \t\n$\"!|:#' -e 18 ndselect_test > ./output/e18again.res

$NDSELECT -S '\s\t\n$\"\041|:\x23' -e 18 -x ndselect_test > ./output/e18x.res 

$NDSELECT -S ' \t\n$\"!|:#' -e 18 -O '\t:\t' ndselect_test > ./output/e18O.res

$NDSELECT -S ' \t\n$\"!|:#' -e 18 -L 7 -O '\t:\t' ndselect_test > ./output/e18L7O.res

$NDSELECT -S ' \t\n$\"!|:#' -e 18 -L 7 -I 4 -O '\t:\t' ndselect_test > ./output/e18L7I4O.res

LIST="b4e15s3F2L8I2Otab.res b4e15s3F2L8I2.res b4e15s3.res e18again.res e18L7I4O.res e18L7O.res e18O.res e18.res e18x.res F2L4Otab.res F2L4.res F4I3b6s2Otab.res F4I3b6s2.res Otabtab.res xF4I3b6s2Otab.res xOtabtab.res"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
