#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -Z 1:2 -Z 2:2 -V  Table1 Table2 > ./output/ZVG2
$NUMDIFF -Z 1:2 -Z 2:2 -f Table1 Table2 > ./output/ZfG2
$NUMDIFF -Z 1:2 -Z 2:2 -f -T Table1 Table2 > ./output/ZfG2T
$NUMDIFF -Z 1:2 -Z 2:2 -f-1 Table1 Table2 > ./output/ZfscG2
$NUMDIFF -Z 1:2 -Z 2:2 -f-1 -T Table1 Table2 > ./output/ZfscG2T
$NUMDIFF -z 1:2 -z 2:2 -f Table1 Table2 > ./output/zfG2
$NUMDIFF -z 1:2 -z 2:2 -f -T Table1 Table2 > ./output/zfG2T
$NUMDIFF -z 1:2 -z 2:2 -f-1 Table1 Table2 > ./output/zfscG2
$NUMDIFF -z 1:2 -z 2:2 -f-1 -T Table1 Table2 > ./output/zfscG2T


LIST="ZVG2 ZfG2 ZfG2T ZfscG2 ZfscG2T zfG2 zfG2T zfscG2 zfscG2T"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done
