#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from os import *
from OBBFuncts import *

class OBBScore:
    def __init__(self):
        self.hitList = {}

    def Get(self):
        return self.hitList

    def Add(self, hitPattern, hitPosition):
        if hitPattern in self.hitList:
            self.hitList[hitPattern].append( hitPosition )
            self.hitList[hitPattern].sort()
        else:
            self.hitList[hitPattern] = [hitPosition]

    def Delete(self,hitPattern, hitPosition):
        if hitPattern in self.hitList:
            self.hitList[hitPattern].remove(hitPosition)
            if len(self.hitList[hitPattern]) == 0:
                del self.hitList[hitPattern]

    def isIn(self, hitPattern, hitPosition):
        hasHit = 0
        try:
            hasHit = hitPosition in self.hitList[hitPattern]
        except KeyError:
            pass # not there, return false
        return hasHit

    def isEmpty(self):
        return len(self.hitList) == 0

    def printScore(self):
        strScore = ""
        for instr in self.hitList:
            strScore += "|"
            for step in self.hitList[instr]:
                strScore += " %d " % step
            strScore += "|\n"
        strScore += "+" + "-" * 20
        debug(strScore)
