import os
import subprocess

# Directory containing .po files
PO_DIR = "../po"

# Directory to output .mo files
OUTPUT_DIR = "txts/translations"

# Ensure the output directory exists
os.makedirs(OUTPUT_DIR, exist_ok=True)

# Loop through all .po files in the PO_DIR
for po_file in os.listdir(PO_DIR):
    if po_file.endswith('.po'):
        full_po_file_path = os.path.join(PO_DIR, po_file)

        # Extract the language code from the file name
        lang, _ = os.path.splitext(po_file)

        # Create output directory for the language if it doesn't exist
        lang_output_dir = os.path.join(OUTPUT_DIR, lang, "LC_MESSAGES")
        os.makedirs(lang_output_dir, exist_ok=True)

        # Output file
        output_file = os.path.join(lang_output_dir, "kickshaw.mo")

        # Run msgfmt command
        subprocess.run(["msgfmt", "--output-file=" + output_file, full_po_file_path])

print("All .po files have been processed.")
