/*  ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.
*/

class Bitmap;
class Block;

class Blockmap
  {
  int _height;
  int _width;
  std::vector< std::vector< int > > data;

  // List of clusters of black bits (Blocks), possibly containing
  // one or more blocks of white bits (holes).
  // The blocks are (more or less) ordered by position from top to bottom,
  // and then from left to right.
  std::list< Block > _block_list;

  void create_block( const Rectangle & r, int id ) throw();
  void delete_block( int id ) throw();
  void join_blocks( int id1, int id2 ) throw();
  void add_point_to_block( int row, int col, int id ) throw();

public:
  int left_neighbor  ( const Rectangle & r , int distance ) const throw();
  int top_neighbor   ( const Rectangle & r , int distance ) const throw();
  int right_neighbor ( const Rectangle & r , int distance ) const throw();
  int bottom_neighbor( const Rectangle & r , int distance ) const throw();

  Blockmap( const Bitmap & source, int column, int debug_level ) throw();

  int height() const throw() { return _height; }
  int width()  const throw() { return _width;  }
  int id( int row, int col ) const throw() { return data[row][col]; }
  const std::list< Block > & block_list() const throw() { return _block_list; }

  void print( FILE * outfile, int debug_level ) const throw();
  };
