/*  GNU OCRAD - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Character : public Rectangle
  {
  struct Guess
    {
    unsigned char ch;
    int value;
    Guess( unsigned char c, int v ) throw() : ch( c ), value( v ) {}
    };

  std::list< Block > _block_list; // the blocks forming this Character
  std::vector< Guess > _guess;	// vector of possible char codes
				// and their associated values
  const Blockmap * _blockmap;	// Blockmap to which this character belongs

  void recognize11( int charbox_vcenter ) throw();
    void recognize110( int charbox_vcenter ) throw();
    void recognize111() throw();
    void recognize112() throw();
  void recognize12( int charbox_vcenter ) throw();
  void recognize13() throw();

public:
  Character( const Block & b ) throw()
    : Rectangle( b ), _blockmap( b.blockmap() )
    { _block_list.push_back( b ); }

  Character( const Rectangle & r, const Blockmap & b ) throw()
    : Rectangle( r ), _blockmap( &b ) {}

  int area() const throw();
  const std::list< Block > & block_list() const throw() { return _block_list; }
//  const std::vector< unsigned char, int > & guess_vector() const throw()
//    { return _guess; }
  const Blockmap * blockmap() const throw() { return _blockmap; }

  void add_block( const Block & b ) throw();
  void only_block( const Block & b ) throw()
    { _block_list.clear(); _block_list.push_back( b ); }
  int blocks() const throw() { return _block_list.size(); }

  void add_guess( unsigned char ch, int value ) throw();
  void insert_guess( int i, unsigned char ch, int value ) throw();
  void delete_guess( int i ) throw();
  void only_guess( unsigned char ch, int value ) throw();
  void swap_guesses( int i, int j ) throw();
  const Guess & guess( int i ) const throw();
  int guesses() const throw() { return _guess.size(); }

  void join( Character & c ) throw();
  void print( FILE * outfile, bool graph, bool recursive ) const throw();
  void xprint( FILE * exportfile ) const throw();

  void recognize1( int charbox_vcenter ) throw();
  };
