/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <cctype>
#include "iso_8859_1.h"


unsigned char ISO_8859_1::base_letter( unsigned char ch ) throw()
  {
  switch( ch )
    {
    case SAGRAVE:
    case SAACUTE:
    case SACIRCU:
    case SATILDE:
    case SADIAER:
    case SARING : return 'a';
    case SEGRAVE:
    case SEACUTE:
    case SECIRCU:
    case SEDIAER: return 'e';
    case SIGRAVE:
    case SIACUTE:
    case SICIRCU:
    case SIDIAER: return 'i';
    case SNTILDE: return 'n';
    case SOGRAVE:
    case SOACUTE:
    case SOCIRCU:
    case SOTILDE:
    case SODIAER: return 'o';
    case SUGRAVE:
    case SUACUTE:
    case SUCIRCU:
    case SUDIAER: return 'u';
    case SYACUTE:
    case SYDIAER: return 'y';
    case CAGRAVE:
    case CAACUTE:
    case CACIRCU:
    case CATILDE:
    case CADIAER:
    case CARING : return 'A';
    case CEGRAVE:
    case CEACUTE:
    case CECIRCU:
    case CEDIAER: return 'E';
    case CIGRAVE:
    case CIACUTE:
    case CICIRCU:
    case CIDIAER: return 'I';
    case CNTILDE: return 'N';
    case COGRAVE:
    case COACUTE:
    case COCIRCU:
    case COTILDE:
    case CODIAER: return 'O';
    case CUGRAVE:
    case CUACUTE:
    case CUCIRCU:
    case CUDIAER: return 'U';
    case CYACUTE: return 'Y';
    default:      return 0;
    }
  }


unsigned char ISO_8859_1::compose( unsigned char base_letter,
                                   unsigned char accent ) throw()
  {
  switch( base_letter )
    {
    case 'a': if( accent == '\'') return SAACUTE;
              if( accent == '`' ) return SAGRAVE;
              if( accent == '^' ) return SACIRCU; break;
    case 'e': if( accent == '\'') return SEACUTE;
              if( accent == '`' ) return SEGRAVE;
              if( accent == '^' ) return SECIRCU; break;
    case '|':
    case 'l':
    case 'i': if( accent == '\'') return SIACUTE;
              if( accent == '`' ) return SIGRAVE;
              if( accent == '^' ) return SICIRCU; break;
    case 'o': if( accent == '\'') return SOACUTE;
              if( accent == '`' ) return SOGRAVE;
              if( accent == '^' ) return SOCIRCU; break;
    case 'v':
    case 'u': if( accent == '\'') return SUACUTE;
              if( accent == '`' ) return SUGRAVE;
              if( accent == '^' ) return SUCIRCU; break;
    case 'A': if( accent == '\'') return CAACUTE;
              if( accent == '`' ) return CAGRAVE;
              if( accent == '^' ) return CACIRCU; break;
    case 'E': if( accent == '\'') return CEACUTE;
              if( accent == '`' ) return CEGRAVE;
              if( accent == '^' ) return CECIRCU; break;
    case 'I': if( accent == '\'') return CIACUTE;
              if( accent == '`' ) return CIGRAVE;
              if( accent == '^' ) return CICIRCU; break;
    case 'O': if( accent == '\'') return COACUTE;
              if( accent == '`' ) return COGRAVE;
              if( accent == '^' ) return COCIRCU; break;
    case 'V':
    case 'U': if( accent == '\'') return CUACUTE;
              if( accent == '`' ) return CUGRAVE;
              if( accent == '^' ) return CUCIRCU; break;
    case 'n': return SNTILDE;
    case 'N': return CNTILDE;
    }
  return 0;
  }


bool ISO_8859_1::isalnum( unsigned char ch ) throw()
  {
  return ( ISO_8859_1::isalpha( ch ) || std::isdigit( ch ) );
  }


bool ISO_8859_1::isalpha( unsigned char ch ) throw()
  {
  return ( std::isalpha( ch ) || base_letter( ch ) );
  }


bool ISO_8859_1::islower( unsigned char ch ) throw()
  {
  if( std::islower( ch ) ) return true;
  ch = base_letter( ch );
  return ( ch && std::islower( ch ) );
  }


bool ISO_8859_1::islower_small( unsigned char ch ) throw()
  {
  if( !std::islower( ch ) ) return false;
  switch( ch )
    {
    case 'a': case 'c': case 'e': case 'm': case 'n': case 'o':
    case 'r': case 's': case 'u': case 'v': case 'w': case 'x':
    case 'z': return true;
    default : return false;
    }
  }


bool ISO_8859_1::islower_small_ambiguous( unsigned char ch ) throw()
  {
  if( !std::islower( ch ) ) return false;
  switch( ch )
    {
    case 'c': case 'o': case 's': case 'u': case 'v': case 'w': case 'x':
    case 'z': return true;
    default : return false;
    }
  }


bool ISO_8859_1::isupper( unsigned char ch ) throw()
  {
  if( std::isupper( ch ) ) return true;
  ch = base_letter( ch );
  return ( ch && std::isupper( ch ) );
  }


bool ISO_8859_1::isvowel( unsigned char ch ) throw()
  {
  if( ch >= 128 ) ch = base_letter( ch );
  if( !ch || !std::isalpha( ch ) ) return false;
  ch = std::tolower( ch );
  return ( ch == 'a' || ch == 'e' || ch == 'i' || ch == 'o' || ch == 'u' );
  }


unsigned char ISO_8859_1::toupper( unsigned char ch ) throw()
  {
  if( ch <= 127 ) return std::toupper( ch );
  switch( ch )
    {
    case SAGRAVE: return CAGRAVE;
    case SAACUTE: return CAACUTE;
    case SACIRCU: return CACIRCU;
    case SATILDE: return CATILDE;
    case SADIAER: return CADIAER;
    case SARING : return CARING;
    case SCCEDI : return CCCEDI;
    case SEGRAVE: return CEGRAVE;
    case SEACUTE: return CEACUTE;
    case SECIRCU: return CECIRCU;
    case SEDIAER: return CEDIAER;
    case SIGRAVE: return CIGRAVE;
    case SIACUTE: return CIACUTE;
    case SICIRCU: return CICIRCU;
    case SIDIAER: return CIDIAER;
    case SNTILDE: return CNTILDE;
    case SOGRAVE: return COGRAVE;
    case SOACUTE: return COACUTE;
    case SOCIRCU: return COCIRCU;
    case SOTILDE: return COTILDE;
    case SODIAER: return CODIAER;
    case SUGRAVE: return CUGRAVE;
    case SUACUTE: return CUACUTE;
    case SUCIRCU: return CUCIRCU;
    case SUDIAER: return CUDIAER;
    case SYACUTE: return CYACUTE;
    default:      return ch;
    }
  }
