/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class Rectangle
  {
  int _left, _top, _right, _bottom;

public:
  Rectangle( int l, int t, int r, int b ) throw();

  int left()   const throw() { return _left;   }
  int top()    const throw() { return _top;    }
  int right()  const throw() { return _right;  }
  int bottom() const throw() { return _bottom; }

  void left  ( int ) throw();
  void top   ( int ) throw();
  void right ( int ) throw();
  void bottom( int ) throw();

  int height() const throw() { return _bottom - _top + 1; }
  int width()  const throw() { return _right - _left + 1; }

  int hcenter() const throw() { return ( _left + _right ) / 2; }
  int vcenter() const throw() { return ( _top + _bottom ) / 2; }
  int hpos( int p ) const throw();
  int vpos( int p ) const throw();

  void add_point( int row, int col ) throw();
  void add_rectangle( const Rectangle & r ) throw();

  bool includes( const Rectangle & r ) const throw();
  bool includes( int row, int col ) const throw();
  bool strictly_includes( const Rectangle & r ) const throw();
  bool includes_hcenter( const Rectangle & r ) const throw();
  bool includes_vcenter( const Rectangle & r ) const throw();
  bool h_includes( const Rectangle & r ) const throw();
  bool h_includes( int col ) const throw();
  bool v_includes( const Rectangle & r ) const throw();
  bool v_includes( int row ) const throw();
  bool h_overlaps( const Rectangle & r ) const throw();
  bool v_overlaps( const Rectangle & r ) const throw();

  int distance( const Rectangle & r ) const throw();
  int distance( int row, int col ) const throw();
  int h_distance( const Rectangle & r ) const throw();
  int h_distance( int col ) const throw();
  int v_distance( const Rectangle & r ) const throw();
  int v_distance( int row ) const throw();
  };
