/*  GNU Ocrad - Optical Character Recognition program
    Copyright (C) 2003, 2004 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

class Vrhomboid			// Rhomboid with two vertical sides.
  {
  int _left, _lvcenter, _right, _rvcenter, _height;

public:
  Vrhomboid( int l, int lc, int r, int rc, int h ) throw();

  int left()     const throw() { return _left;     }
  int lvcenter() const throw() { return _lvcenter; }
  int right()    const throw() { return _right;    }
  int rvcenter() const throw() { return _rvcenter; }
  int height()   const throw() { return _height;   }

  void left( int l ) throw();
  void lvcenter( int lc ) throw() { _lvcenter = lc; }
  void right( int r ) throw();
  void rvcenter( int rc ) throw() { _rvcenter = rc; }
  void height( int h ) throw();
  void extend_to_left( int l ) throw();
  void extend_to_right( int r ) throw();

  int vcenter( int col ) const throw();
  int bottom( int col ) const throw() { return vcenter( col ) + (_height / 2); }
  int top( int col ) const throw() { return bottom( col ) - _height + 1; }
  int width() const throw() { return _right - _left + 1; }
  int size() const throw() { return _height * width(); }

  bool includes( const Rectangle & r ) const throw();
  bool includes( int row, int col ) const throw();
  };
