/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.noyau2d;

import java.io.IOException;
import opale.module2d.noyau2d.MalformedFileException;
import opale.module2d.noyau2d.Matrix2D;
import opale.module2d.noyau2d.OIJ;
import opale.module2d.noyau2d.Object2D;
import opale.module2d.noyau2d.Pack2D;
import opale.module2d.noyau2d.Transformable;
import opale.tools.RFile;
import opale.tools.WFile;

public class Point2D
extends Object2D
implements Transformable,
Cloneable {
    protected double x;
    protected double y;

    public Point2D() {
        System.out.println("Dans Point2D()");
    }

    public Point2D(OIJ oIJ) {
        super(oIJ);
    }

    public Point2D(OIJ oIJ, double d, double d2) {
        super(oIJ);
        this.x = d;
        this.y = d2;
    }

    public Point2D(Point2D point2D) {
        super(point2D.getOIJ());
        this.x = point2D.x;
        this.y = point2D.y;
    }

    public void changeOIJ(OIJ oIJ) {
        Matrix2D matrix2D = new Matrix2D();
        this.getOIJ().matPassage(oIJ, matrix2D);
        double[] dArray = matrix2D.compute(this.x, this.y);
        this.x = dArray[0];
        this.y = dArray[1];
        this.setOIJ(oIJ);
    }

    public Object clone() {
        Point2D point2D = (Point2D)super.clone();
        point2D.x = this.x;
        point2D.y = this.y;
        return point2D;
    }

    public boolean equals(Object object) {
        if (object instanceof Point2D) {
            Point2D point2D = (Point2D)object;
            return this.x == point2D.x && this.y == point2D.y && this.getOIJ().equals(point2D.getOIJ());
        }
        return false;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public void homothetie(Point2D point2D, double d) {
        this.x = d * (this.x - point2D.x) + point2D.x;
        this.y = d * (this.y - point2D.x) + point2D.y;
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("X")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.x = rFile.dval;
            return 0;
        }
        if (string.equals("Y")) {
            int n = rFile.next();
            if (n != RFile.RF_DOUBLE) {
                return -1;
            }
            this.y = rFile.dval;
            return 0;
        }
        return -1;
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        double d4 = this.x;
        this.x = d4 * d2 - this.y * d3;
        this.y = d4 * d3 + this.y * d2;
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(-d, -d2);
        this.rotate(d3);
        this.translate(d, d2);
    }

    public final void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public final void setLocation(Point2D point2D) {
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.changeOIJ(this.getOIJ());
        this.x = point2D2.x;
        this.y = point2D2.y;
    }

    public String toString() {
        String string = "(" + this.x + "; " + this.y + ")";
        return string;
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("X " + this.x);
        wFile.writeln("Y " + this.y);
    }
}

