/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.noyau2d;
import java.awt.*;
import javax.swing.*;

/**
* Cette classe constitue une boite  outil pour dessiner dans un systme de coordonnes.
* LEs mthodes proposes s'apparentent  celles de la classe <code>java.awt.Graphics</code> sauf qu'elles travaillent dans un repre utilisateur 2D.
* @author OC
* @version 0.1
*/

public class Pen2D
{

private CoordSystem repere; //le repere2D
private Graphics g; //crayon en coordonnes reelles 
private Color couleur;

/**
* Constructeur a partir d'un Graphics et d'un repere2D
* @param Graphics g
* @param CoordSystem repere
* @since Opale 0.1
*/
public Pen2D(Graphics g,CoordSystem repere){

this.repere=repere;
this.g= g;
//clip();
}

/**
* Retourne l'instance de Graphics qui sert  dessiner.
* @return Graphics , l'instance de Graphics utilis.
* @since Opale 0.11
*/
public Graphics getGraphics()
	{
	return g;
	}

/**
* Methode pour eviter les debordements hors la feuille
* @since Opale 0.1
*/
public void clip()
{
g.setClip(repere.getXinf(),repere.getYinf(),repere.getWidth()+1,repere.getHeight()+1);
}

/**
* Methode pour limiter les actions graphiques dans un rectangle
* @param double x1
* @param double y1
* @param double largeur
* @param double hauteur
* @since Opale 0.1
*/
/*public void clip(double x1,double y1,double largeur,double hauteur)
{
g.setClip(repere.X(x1,y1),repere.Y(x1,y1),repere.X(largeur,0),repere.Y(hauteur));
}*/

/**
* Dessine un point
* @param double x
* @param double y
* @since Opale 0.1
*/
public void drawPoint(double x,double y){drawLine(x,y,x,y);}


/**
* Dessine une ligne
* @param double x1,y1,x2,y2
* @since Opale 0.1
*/
public void drawLine(double x1,double y1,double x2,double y2)
{
g.drawLine(repere.X(x1,y1),repere.Y(x1,y1),repere.X(x2,y2),repere.Y(x2,y2));
}

/**
* Dessine un cercle
* @param double x,y, les coordonnes du centre du cercle
* @param double r, le rayon du cercle
* @since Opale 0.1
*/
public void drawCircle(double x,double y,double r)
{
if ( r >= 0 )
	g.drawOval(repere.X(x-r,y+r),repere.Y(x-r,y+r),Math.abs(repere.X(r*2,0) - repere.X(0,0)),Math.abs(repere.Y(0,r*2) - repere.Y(0,0)));
else {} // lancer une exception!??
}

/**
* Dessine une croix '+' centr en (x, y)
* @param double x,y, les coordonnes du centre
* @param int taille, la taille en pixels ecrans
* @since Opale 0.1
*/
public void drawPlus(double x,double y,int taille )
{
g.drawLine(repere.X(x,y)-taille,repere.Y(x,y),repere.X(x,y)+taille,repere.Y(x,y));
g.drawLine(repere.X(x,y),repere.Y(x,y)-taille,repere.X(x,y),repere.Y(x,y)+taille);
}

/**
* Dessine une croix 'X' centre en (x, y)
* @param double x,y, les coordonnes du centre
* @param int taille, la taille en pixels ecrans
* @since Opale 0.1
*/
public void drawX(double x,double y,int taille )
{
g.drawLine(repere.X(x,y)-taille,repere.Y(x,y)-taille,repere.X(x,y)+taille,repere.Y(x,y)+taille);
g.drawLine(repere.X(x,y)-taille,repere.Y(x,y)+taille,repere.X(x,y)+taille,repere.Y(x,y)-taille);
}

/**
* Dessine un carr centr en (x, y)
* @param double x,y, les coordonnes du centre
* @param int taille, la taille en pixels ecrans du cot.
* @since Opale 0.1
*/
public void drawSquare(double x,double y,int taille )
	{
	g.drawRect(repere.X(x,y)-(taille>>1),repere.Y(x,y)-(taille>>1),taille,taille);
	}

/**
* Dessine un objet 2d graphique. Effectue un chagement de repre si necessaire.
* @param GObject2D gob.
* @since Opale 0.11
*/
public void draw(GObject2D gob)
	{
	if (gob instanceof Object2D)
		{
		Object2D ob = (Object2D) gob.clone();
		ob.changeOIJ(repere.getOIJ());
		((GObject2D) ob).draw(this);
		}
	else
		gob.draw(this);
	}
		

/**
* Dessine un cercle centr en (x, y)
* @param double x,y, les coordonnes du centre
* @param int taille, la taille en pixels ecrans du rayon.
* @since Opale 0.1
*/
public void drawCircle(double x,double y,int taille)
	{
	g.drawOval(repere.X(x,y)-(taille>>1),repere.Y(x,y)-(taille>>1),taille,taille);
	}

/**
* Dessine un diamand centr en (x, y)
* @param double x,y, les coordonnes du centre
* @param int taille, la taille en pixels ecrans.
* @since Opale 0.1
*/
public void drawDiamond(double x,double y,int taille)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	
	g.drawLine(xR+taille,yR,xR,yR+taille);
	g.drawLine(xR,yR+taille,xR-taille,yR);
	g.drawLine(xR-taille,yR,xR,yR-taille);
	g.drawLine(xR,yR-taille,xR+taille,yR);
	}
/**
* Dessine un triangle quilatral vers le haut et centr en (x, y)
* @param double x,y, les coordonnes du centre.
* @param double a, le demi cot du triangle en pixel.
* @since Opale 0.1
*/
public void drawTriangleUp(double x,double y,int a)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	int h = (int) Math.round(0.58 * a);
	g.drawLine(xR,yR-2*h,xR+a,yR+h);
	g.drawLine(xR+a,yR+h,xR-a,yR+h);
	g.drawLine(xR-a,yR+h,xR,yR-2*h);
	}

/**
* Dessine un triangle quilatral vers le bas et centr en (x, y)
* @param double x,y, les coordonnes du centre.
* @param double a, le demi cot du triangle en pixel.
* @since Opale 0.1
*/
public void drawTriangleDown(double x,double y,int a)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	int h = (int) Math.round(0.58 * a);
	g.drawLine(xR,yR+2*h,xR+a,yR-h);
	g.drawLine(xR+a,yR-h,xR-a,yR-h);
	g.drawLine(xR-a,yR-h,xR,yR+2*h);
	}

/**
* Dessine un triangle quilatral vers la gauche et centr en (x, y)
* @param double x,y, les coordonnes du centre.
* @param double a, le demi cot du triangle en pixel.
* @since Opale 0.1
*/
public void drawTriangleLeft(double x,double y,int a)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	int h = (int) Math.round(0.58 * a);
	g.drawLine(xR+h,yR-a,xR+h,yR+a);
	g.drawLine(xR+h,yR+a,xR-2*h,yR);
	g.drawLine(xR-2*h,yR,xR+h,yR-a);
	}

/**
* Dessine un triangle quilatral vers la droite et centr en (x, y)
* @param double x,y, les coordonnes du centre.
* @param double a, le demi cot du triangle en pixel.
* @since Opale 0.1
*/
public void drawTriangleRight(double x,double y,int a)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	int h = (int) Math.round(0.58 * a);
	g.drawLine(xR-h,yR-a,xR-h,yR+a);
	g.drawLine(xR-h,yR+a,xR+2*h,yR);
	g.drawLine(xR+2*h,yR,xR-h,yR-a);
	}

/**
* Dessine un tiret parallle  l'axe des X.
* @pram double x, l'abscisse du tiret.
* @param double y, ordonne du tiret.
* @param int, la taille du tiret en pixels.
* @since Opale 0.1
*/
public void drawXtick(double x,double y, int s)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	
	g.drawLine(xR-s,yR,xR+s,yR);
	}

/**
* Dessine un tiret parallle  l'axe des Y.
* @pram double x, l'abscisse du tiret.
* @param double y, ordonne du tiret.
* @param int, la taille du tiret en pixels.
* @since Opale 0.1
*/
public void drawYtick(double x,double y, int s)
	{
	int xR = repere.X(x,y);
	int yR = repere.Y(x,y);
	
	g.drawLine(xR,-s+yR,xR,s+yR);
	}

/**
* Dessine une ligne entre deux points.
* @param Point2D a,b les deux extrmits.
* @since Opale 0.1
*/
public void drawLine(Point2D a, Point2D b)
	{
	drawLine(a.x,a.y,b.x,b.y);
	}

/**
* Dessine une ligne horizontale de toute la longueur et d'altitude donne.
* @param double h la hauteur de la ligne.
* @since Opale 0.1
*/
public void drawHLine(double h)
	{
	drawLine(repere.getXmin(),h,repere.getXmax(),h);
	}

/**
* Dessine une ligne verticale de toute la longueur et d'abscisse donne.
* @param double x l'abscisse de la ligne.
* @since Opale 0.1
*/
public void drawVLine(double x)
	{
	drawLine(x,repere.getYmin(),x,repere.getYmax());
	}

/**
* Dessine une flche.
* @param double xo, yo l'origine virtuelle du segment de flche.(sert  prciser la direction et le sens de la flche)
* @param double x,y la position de la flche.
* @param int taille la taille en pixels de la flche.
* @since Opale 0.1
*/
public void drawArrow(double xo,double yo,double x, double y, int taille)
	{
		int xR = repere.X(x,y);
		int yR = repere.Y(x,y);
		int xoR = repere.X(xo,yo);
		int yoR = repere.Y(xo,yo);
		double norme = Vector2D.norm(xR-xoR,yR-yoR);

		//		System.out.println("norme =" +norme);
	 	if (norme != 0)
			{
			double nx = -(yR-yoR)/norme;
			double ny = (xR-xoR)/norme;
			//System.out.println("nx =" +nx);
			//System.out.println("ny =" +ny);
				
			double xh = xR - taille * ny;
			double yh = yR + taille * nx;
			g.drawLine((int) (xh+nx*5),(int) (yh+ny*5),xR,yR);
			g.drawLine((int) (xh-nx*5),(int) (yh-ny*5),xR,yR);

			}
		
	}

/**
* Dessine un rectangle.
* @param double x, y les coordonnes du point suprieur gauche.
* @param double w, h la largeur et la hauteur du rectangle.
* @since Opale 0.1
*/
public void drawRect(double x, double y, double w, double h)
	{
	g.drawRect(repere.X(x,y),repere.Y(x,y),repere.X(w,0),repere.Y(0,h));
	}

/**
* Ecris du texte au point spcifi.
* @param String, le texte  afficher.
* @param double x, y les coordonnes du point.
* @since Opale 0.1
*/
public void drawString(String text, double x, double y)
	{
	g.drawString(text,repere.X(x,y),repere.Y(x,y));
	}

/**
* Ecris du texte au point spcifi avec un dcalage donn en pixels.
* @param String, le texte  afficher.
* @param double x, y les coordonnes du point.
* @param int dx, dy dcalage relatif en x et en y.
* @since Opale 0.1
*/
public void drawString(String text, double x, double y, int dx, int dy)
	{
	g.drawString(text,repere.X(x,y)+dx,repere.Y(x,y)+dy);
	}
	

/**
* Change la couleur du Crayon
* @param Color couleur, la nouvelle couleur
*/
public void setColor(Color couleur)
	{
	this.couleur=couleur;
	g.setColor(couleur);
	}

/**
* Retourne la couleur courante du crayon
* @return Color, la couleur courante
*/
public Color getColor()
	{
	return couleur;
	}

/**
* Retourne le repere 2D.
* @return CoordSystem le repere.
* @since Opale 0.1
*/
public final CoordSystem getCoordSyst()
	{
	return repere;
	}


}
 

