/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;

import opale.mathtools.*;
import opale.tools.*;

/**
* Classe abstraite servant  designer un schma en temps pour les quations diffrentielles ordinaires. Une mthode est  implemnter pour construire une classe instanciable : la mthode forward(Equation eq) qui dfinit comme effectuer un pas de temps.
* @version 0.1
* @author O.C.
*/

public abstract class TimeScheme implements ObjectODE
{
private double tinit, tmax, tc;	
private double dt;
private int Nstep;
private Problem pb;

//private DVect[] past;
private DVect present;
//private int npast;
	
	
/**
* Cette mthode doit renvoyer le nombre de valeurs de l'inconnue  stocker dans le pass. Par exemple pour un schma d'Euler explicite ce nombre vaut 0 car pour calculer le temps n+1; on a besoin seulement des valeurs au temps n qui sont automatiquement stockes dans le'instance de DVect retourn par present().
* @return int, le nombre de valeurs  stocker.
* @since Opale 0.11
*/	
//abstract public int  npast();

/**
Cette mthode doit tre implmneter par une classe fille pour dfinir un schma en temps. Elle prend en argument une quation et elle est charg de calculer l'inconnue au temps courant (accessible par la mthode present()). A l'entre dans cette mthode pour le calcul du temps n, la mthode present() renvoie l'inconnue au temps n juste prcdent.
* @param Equation, l'quation pour laquelle on veut avancer en temps.
* @since Opale 0.11
*/
abstract public void forward(Equation eq);

	
public TimeScheme()
	{
	pb = null;
	tinit = 0;
	tmax = 1;
	Nstep = 11;
	}		

/**
* Renvoie les inconnues des temps prcdents. La mthode npast() qui doit tre implmente par une classe fille renvoie le nombre de pas de temps stocks. Attention, les valeurs sont ranges par temps dcroissants : par exmple si on est au temps n, l'appel past(0) renvoie l'inconnue au temps n-1, past(1) au temps n-2...
ATTENTION : l'instance de DVect renvoye contient en premire composante le temps courant, puis les composantes suivantes (gal  la dimension du problme trait) contiennent les valeurs de l'inconnue. 
* @param int i, l'indice du temps dsir.
* @return DVect, l'inconnue au temps souhait.
* @since Opale 0.11
*/ 
/*final public DVect past(int i)
	{
	return past[i];
	}
*/

/**
* Renvoie l'inconnue au temps prsent. ATTENTION : l'instance de DVect renvoye contient en premire composante le temps courant, puis les composantes suivantes (gal  la dimension du problme trait) contiennent les valeurs de l'inconnue. 
* @return DVect, l'inconnue au temps prsent.
* @since Opale 0.11
*/ 
final public DVect present()
	{
	return present;
	}
		
/**
* Fixe les bornes du domaine d'tude en temps.
* @param double t0, le temps de dpart.
* @param double t1, le temps final.
* @since Opale 0.11
*/
public final void set(double t0, double t1)
	{
	tinit = Math.min(t0,t1);
	tmax = Math.max(t0,t1);
	}
	
/**
* Fixe le nombre de pas de temps  effectuer dans le calcul.
* @param int n, le nombre de pas de temps.
* @since Opale 0.11
*/
public final void setNstep(int n)
	{
	Nstep = Math.max(3,Math.abs(n));
	}

/**
* Renvoie le nombre d epas de temps du calcul.
* @return int, le nombre de pas de temps.
* @since Opale 0.11
*/
public final int getNstep()
	{
	return Nstep;
	}
	
/**
* Permet d'attacher un problme d'ODE au schma en temps. Aucun calcul ne peut dmarrer sans attacher de problme.
* @param Problem, le problme  attacher.
* @since Opale 0.11
*/ 	
public final void setPb(Problem pb)
	{
	this.pb = pb;
	}
	

	
/**
* Renvoie le problme attach au schma en temps courant.
* @return Problem, le problme attach.
* @since Opale 0.11
*/
public final Problem getPb()
	{
	return pb;
	}

/**
* Renvoie la borne infrieure du domaine dtude.
* @return double, le temps minimum.
* @since Opale 0.11
*/
public final double tmin()
	{
	return tinit;
	}
/**
* Renvoie la borne suprieure du domaine dtude.
* @return double, le temps maximum.
* @since Opale 0.11
*/
public final double tmax()
	{
	return tmax;
	}
	

/**
* Renvoie la valeur du pas de temps calcul comme constante.
* @return double, le pas de temps.
* @since Opale 0.11
*/
public final double dt()
	{
	return dt;
	}
	
/**
* Renvoie le temps courant.
* @return double, le temps courant.
* @since Opale 0.11
*/
public final double time()
	{
	return tc;
	}	


/**
* Initialise le calcul (rservation mmoire, calcul du pas de temps...). A appeller OBLIGATOIREMENT avant chaque calcul.
* @since Opale 0.11
*/
public void init()
	{
	if (pb == null)
	{
	System.err.println("Le schma n'est associ  aucun problme.\nArret anormal du calcul.");
	System.exit(-1);
	}
	
	
	/*if (npast()<0) 
	{
	System.err.println("Erreur le nombre de valeurs temporelles  stocker est ngatif!\nArret anormal du calcul.");
	System.exit(-1);
	}
	
	int i;
	past = new DVect[npast()];
	for (i=0;i<npast();i++)
		past[i] = new DVect(1+pb.dim());*/
	present = new DVect(pb.dim());
	present.set(pb.getInit());
	dt = (tmax-tinit)/(Nstep-1);
	tc = tinit;
	
	}

/**
* Met  jour le calcul (incrmente le pas de temps, stocke les inconnues...). A appeller  chaque fin de calcul d'un pas de temps OBLIGATOIREMENT.
* @since Opale 0.11
*/
public void update()
	{
	tc+=dt;
	/*present().set(0,tc);
	int i,np=npast();
	if (npast()>0)
		{
		for (i=0;i<np-1;i++)
			past[np-1-i].set(past[np-i-2]);
		past[0].set(present());
		}*/
	}	
	
public void readFile(RFile f,ODE ode) {}
public void writeFile(WFile f, ODE ode)
	{
	f.writeln("{");
	f.writeln("tmin "+tinit);
	f.writeln("tmax "+tmax);
	f.writeln("N "+Nstep);
	f.writeln("}");
	}


	
}
