/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.tools;
import java.io.*;

/**
* Cette classe encapsule des methodes pour lire les types de base stock dans un fichier et sous forme ASCII.
* @version 0.1
* @author O.C.
*/

public class RFile
{
private FileReader rf;
private StreamTokenizer in;
private String name;

public static int RF_EOF = -1;
public static int RF_DOUBLE = 1;
public static int RF_STRING = 2;


public double dval;
public String sval;

public RFile(String name) throws IOException
	{
	this.name =name;
	in = new StreamTokenizer(rf = new FileReader(name));
	in.wordChars(33,255);
	in.slashStarComments(false);
	in.slashSlashComments(true);
	}
	
public RFile(InputStream inp) throws IOException
	{
	this.name = inp.toString();
	Reader r = new BufferedReader(new InputStreamReader(inp));
	in = new StreamTokenizer(r);
	in.wordChars(33,255);
	in.slashStarComments(false);
	in.slashSlashComments(true);
	}
	
	
/**
* Cette mthode next() renvoie un entier indiquant le type de la prochaine
entit lu, soit un  nombre soit une chaine de caractres soit la fin du fichier. Si c'et un niombre on
rcupre sa valeur dans le champ public dval, sinon on rcupre la valeur de la
chaine dans sval.
* @return int type, RF_EOF = fin de fichier; RF_NUMBER = nombre; RF_STRING =
chaine de caratres.
* @since Opale 0.1
*/


public int next() throws IOException
	{
	int type;
	String temp;
	
	type = in.nextToken();
	
	if ( type == StreamTokenizer.TT_EOF )
		return RF_EOF;
	else if ( type == StreamTokenizer.TT_NUMBER )
		{
		try
			{
			dval = in.nval;
			return RF_DOUBLE;
			}
		catch (NumberFormatException e)
			{
			}
		}
	else if ( type == StreamTokenizer.TT_WORD )
		{
		sval = in.sval;
		return RF_STRING;
		}
		
	return 0;
	} 

public String toString()
	{
	return name;
	}


}

