/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

/**
* Cette interface est  implementer par toutes les classes designant des objets * tracables avec un Pen2D dans un repere2D
* @author O.C.
* @since Opale-2d 0.1
*/

public interface GObject2D extends Cloneable
{

/**
* Surcharge de toString()
*/
public String toString();



/**
* Methode indiquant la procedure de dessin des objets de la classe
* @param Pen2D crayon, le crayon pour dessiner en 2D dans un repere2D
*/
public void draw(Pen2D crayon);

/**
* Renvoie les infos de l'instance
* @return InfoObjet, info sur l'objet
*/
public InfoObject getInfo();

public Object clone();


}



