package opale.tools;

/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


/**
* The class <code>Chronometer</code> permits to measure the time, with millisecond precision.
* @author O.C.
* @date 07/01/2001
* @since Opale-Tools 0.11
*/


public class Chronometer
{
private static long begin,end,time;
/**
* Start the timer.
*/
public static void start()
	{
	time = 0;
	begin = System.currentTimeMillis();
	}
/**
* Stop the timer.
*/
public static void stop()
	{
	end = System.currentTimeMillis();
	time += end-begin;
	}


/**
* Resume the timer, that is stopped by <code>stop()</code>.
*/
public static void resume()
	{
	begin = System.currentTimeMillis();
	}
/**
* Return the elapsed time in milliseconds.
* @return int long, the time.
*/
public static long time()
	{
	return time;
	}
	
public static void main(String[] arg)
	{
	Chronometer.start();
	for (int i = 1;i<1000000;i++)
		{}
	Chronometer.stop();
	Chronometer.resume();
	for (int i = 1;i<1000000;i++)
		{}
	Chronometer.stop();
	System.out.println(Chronometer.time());
	}
}


