/*
 * Decompiled with CFR 0.152.
 */
package opale.matrix.solver;

import opale.mathtools.DVect;
import opale.matrix.SymDecomposition;
import opale.matrix.SymMatrix;
import opale.matrix.SymSolver;
import opale.tools.Debug;

public class SolverCholesky
implements SymSolver,
SymDecomposition {
    private double[] BtB;
    private int n;
    private boolean sdp = true;

    public void decomp(SymMatrix symMatrix) {
        this.sdp = true;
        this.n = symMatrix.getDim();
        this.BtB = symMatrix.getInternalArray();
        Debug.print("n = " + this.n);
        int n = 0;
        while (n < this.n) {
            int n2 = n;
            while (n2 < this.n) {
                int n3 = n * (n + 1) / 2;
                int n4 = n2 * (n2 + 1) / 2;
                double d = this.BtB[n4 + n];
                int n5 = 0;
                while (n5 < n) {
                    d -= this.BtB[n3++] * this.BtB[n4++];
                    ++n5;
                }
                if (n == n2) {
                    this.sdp &= d > 0.0;
                    this.BtB[n3] = Math.sqrt(d);
                } else {
                    this.BtB[n4] = d / this.BtB[n3];
                }
                ++n2;
            }
            ++n;
        }
        Debug.print("BtB = " + this.BtB[0] + " " + this.BtB[1] + " " + this.BtB[2] + " " + this.BtB[3] + " " + this.BtB[4] + " " + this.BtB[5] + " ");
    }

    public void solve(SymMatrix symMatrix, DVect dVect, DVect dVect2) {
        int n;
        double d;
        int n2;
        if (!this.sdp) {
            throw new IllegalArgumentException("Matrix must be symmetric positive definite !!");
        }
        double[] dArray = dVect.toArray();
        double[] dArray2 = dVect2.toArray();
        int n3 = 0;
        while (n3 < this.n) {
            n2 = n3 * (n3 + 1) / 2;
            d = dArray[n3];
            n = 0;
            while (n < n3) {
                d -= this.BtB[n2++] * dArray2[n];
                ++n;
            }
            dArray2[n3] = d / this.BtB[n2];
            ++n3;
        }
        n3 = this.n - 1;
        while (n3 >= 0) {
            int n4;
            n2 = n4 = (n3 + 1) * n3 / 2 + n3;
            d = dArray2[n3];
            n = n3 + 1;
            while (n < this.n) {
                d -= this.BtB[n2 += n] * dArray2[n];
                ++n;
            }
            dArray2[n3] = d / this.BtB[n4];
            --n3;
        }
    }

    public double determinant() {
        double d = 1.0;
        int n = 0;
        while (n < this.n) {
            d *= this.BtB[n * (n + 1) / 2 + n];
            ++n;
        }
        d *= d;
        return d;
    }

    public static void main(String[] stringArray) {
        SymMatrix symMatrix = new SymMatrix(3);
        DVect dVect = new DVect(3);
        DVect dVect2 = new DVect(3);
        symMatrix.set(0, 0, 4.0);
        symMatrix.set(1, 0, 0.0);
        symMatrix.set(1, 1, 1.0);
        symMatrix.set(2, 0, 1.0);
        symMatrix.set(2, 1, 1.0);
        symMatrix.set(2, 2, 3.0);
        dVect.set(0, 1.0);
        dVect.set(1, 0.0);
        dVect.set(2, 3.0);
        System.out.println(symMatrix);
        SolverCholesky solverCholesky = new SolverCholesky();
        solverCholesky.decomp(symMatrix);
        solverCholesky.solve(null, dVect, dVect2);
        System.out.println("det = " + solverCholesky.determinant());
        System.out.println(symMatrix);
        System.out.println(dVect2);
    }
}

