/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.NoStepsizeControl;
import opale.ode.ObjectODE;
import opale.ode.Problem;
import opale.ode.StepsizeControl;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.Stdio;

public abstract class TimeScheme
extends ObjectODE {
    private double tinit = 0.0;
    private double tmax = 1.0;
    private double tc;
    private double dtmax = 1.0E9;
    private double dtmin = 0.0;
    private double dt;
    private int Nstep = 11;
    private Problem pb = null;
    private StepsizeControl stepcontrol;
    private DVect present;
    private DVect past;

    public abstract void forward(Equation var1);

    public final DVect present() {
        return this.present;
    }

    public final void set(double d, double d2) {
        this.tinit = Math.min(d, d2);
        this.tmax = Math.max(d, d2);
    }

    public final void setNstep(int n) {
        this.Nstep = Math.max(3, Math.abs(n));
    }

    public final int getNstep() {
        return this.Nstep;
    }

    public final void setPb(Problem problem) {
        this.pb = problem;
    }

    public final Problem getPb() {
        return this.pb;
    }

    public final void setStepsizeControl(StepsizeControl stepsizeControl) {
        this.stepcontrol = stepsizeControl;
    }

    public final double tmin() {
        return this.tinit;
    }

    public final double tmax() {
        return this.tmax;
    }

    public final double dtmax() {
        return this.dtmax;
    }

    public final double dtmin() {
        return this.dtmin;
    }

    public final void dtmax(double d) {
        this.dtmax = d;
    }

    public final void dtmin(double d) {
        this.dtmin = d;
    }

    public final double dt() {
        return this.dt;
    }

    public final void dt(double d) {
        this.dt = d;
    }

    public final double time() {
        return this.tc;
    }

    public void init() {
        if (this.pb == null) {
            System.err.println("No problem for this scheme !.\nStop.");
            System.exit(-1);
        }
        if (this.stepcontrol == null) {
            this.stepcontrol = new NoStepsizeControl(this);
        } else {
            this.stepcontrol.setTS(this);
        }
        this.present = new DVect(this.pb.dim());
        this.past = new DVect(this.pb.dim());
        this.present.set(this.pb.getInit());
        this.past.set(this.pb.getInit());
        this.dt = (this.tmax - this.tinit) / (double)(this.Nstep - 1);
        if (this.dt < this.dtmin) {
            this.dt = this.dtmin;
        } else if (this.dt > this.dtmax) {
            this.dt = this.dtmax;
        }
        this.tc = this.tinit;
    }

    public boolean update() {
        if (this.stepcontrol.update()) {
            this.tc += this.dt;
            this.past.set(this.present);
            return true;
        }
        Stdio.println("Step time refused. New step : dt = " + this.dt);
        this.present.set(this.past);
        return false;
    }

    public int readKeyWord(String string, StreamTokenizer streamTokenizer, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("N")) {
            int n = streamTokenizer.nextToken();
            this.Nstep = (int)streamTokenizer.nval;
            return 0;
        }
        if (string.equals("tmin")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tinit = streamTokenizer.nval;
            return 0;
        }
        if (string.equals("tmax")) {
            int n = streamTokenizer.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tmax = streamTokenizer.nval;
            return 0;
        }
        if (string.equals("stepcontrol")) {
            int n = streamTokenizer.nextToken();
            if (n != -3) {
                throw new InvalidFormatException("Incorrect data file : Error reading a stepcontrol method in a time scheme ");
            }
            if (!opaleSet.contains(streamTokenizer.sval) || opaleSet.getObject(streamTokenizer.sval) == null) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + streamTokenizer.sval + " doesn't exist !!");
            }
            if (!(opaleSet.getObject(streamTokenizer.sval) instanceof StepsizeControl)) {
                throw new InvalidFormatException("Incorrect data file : indentifier " + streamTokenizer.sval + " is not a step control method !!");
            }
            this.stepcontrol = (StepsizeControl)opaleSet.getObject(streamTokenizer.sval);
            return 0;
        }
        return -1;
    }

    public void write(PrintWriter printWriter, OpaleSet opaleSet) {
        printWriter.println("{");
        printWriter.println("tmin " + this.tinit);
        printWriter.println("tmax " + this.tmax);
        printWriter.println("N " + this.Nstep);
        if (this.stepcontrol != null && this.stepcontrol.getId() != null) {
            printWriter.println("stepcontrol " + this.stepcontrol.getId());
        }
        printWriter.println("}");
    }
}

