/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d;
import opale.tools.*;
import java.io.*;

/**
* This abstract class is the root of the class hierarchy that represents an object 2D.
* @since Opale-2d 0.15, Elle tend la classe OpaleObject 
* @author OC
* @since Opale-2d 0.1
*/
public abstract class Object2D extends OpaleObject implements Cloneable
{
private OIJ rep;	//Tout objet 2d est dfini dans un repre OIJ.
/**
* Construct and initialize with the absolute OIJ.
*/
public Object2D()
	{
	this.rep = OIJ.OIJ_ABSOLUTE;
	}
	
/**
* Construct and initialize with an specified OIJ.
* @param OIJ rep, an instance of <code>OIJ</code>.
*/
public Object2D(OIJ rep)
	{
	this.rep = rep;
	}

/**
* Set the OIJ basis of this object.
* @param OIJ rep,  the new OIJ.
*/
public void setOIJ(OIJ rep)
	{
	this.rep = rep;
	}
	
	
/**
* Return the instance <code>OIJ</code> of this object.
* @return OIJ rep, the basis of this object.
*/
public OIJ getOIJ()
	{
	return rep;
	}
	
/**
* Create a new object of the same class and with the same contents as this vector.
* @return Object, a clone of this instance.
* @exception  OutOfMemoryError if there is not enough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	/*try
		{*/
		Object2D obj = (Object2D) super.clone();
		obj.rep = rep;
		return obj;
		/*}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError(""+e);
		}*/
    }


	
/**
* Compute the changement of OIJ for this object.
* @param OIJ rep, the new OIJ.
*/	
public abstract void changeOIJ(OIJ rep);


/**
* Return a string representation of this object.
*/
public abstract String toString();

/**
* Write informations about this object in a stream.
* @param WFile f, the file in writing.
*/
public void write(PrintWriter f,OpaleSet pack) throws InvalidFormatException
	{
	f.println("{");
	if (!pack.contains(getOIJ())) throw new InvalidFormatException("Error writing the file "+f+" : the OIJ "+getOIJ()+" doesn't exist !!");
	f.println("OIJ "+getOIJ().getId());
	writeMore(f,pack);
	f.println("}");
	}
/**
* Write complementary information in a stream.
* @param WFile f, the file in writing .
*/
public abstract void writeMore(PrintWriter f,OpaleSet pack) throws InvalidFormatException;
		


/**
* Read in a stream the construction of this object calling the method <code>readKeyWord().</code>
* @param RFile f, the file to read.
* @prama Pack2D p, instance of <code>Pack2D</code> that contains the requiered objects (OIJ, others objects 2d...).
*/
public void read(StreamTokenizer f,OpaleSet pack) throws java.io.IOException,InvalidFormatException
	{
	int type;
	OIJ lerepere=null;

	type = f.nextToken();	//on lit la premiere '{'
	if ( (type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new InvalidFormatException("Data file "+f+" is wrong !!");
	type = f.nextToken();	
	do
		{
		if (type != StreamTokenizer.TT_WORD)  throw new InvalidFormatException("Data file "+f+" is wrong : we want a keyword !!");
		if ((f.sval).equals("OIJ"))
			{
			type =f.nextToken();
			if (type != StreamTokenizer.TT_WORD) throw new InvalidFormatException("Data file "+f+" is non valid  : error reading an OIJ");
			if (Debug.On) Debug.print("Dans Object2D : "+pack.contains(f.sval));
			if (Debug.On) Debug.print("Dans Object2D : "+pack.getObject(f.sval));
			if ( (!pack.contains(f.sval)) || (pack.getObject(f.sval)) == null) throw new InvalidFormatException("Data file "+f+" is wrong  : the identifiant "+f.sval+" doesn't exist !!");
			if (pack.getObject(f.sval) instanceof OIJ) lerepere = (OIJ) pack.getObject(f.sval);
			else throw new InvalidFormatException("Data file "+f+" is non valid  : the identifiant "+f.sval+" is not a OIJ !!");
			
			} 
			
		else if (readKeyWord(f.sval,f,pack) == -1) throw new InvalidFormatException("Data file "+f+" is non valid   : error reading a keyword "+f.sval+" !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );

	if (lerepere == null) throw new InvalidFormatException("No OIJ for this object !!"+this);
	setOIJ(lerepere);
	
	
	}

/**
* Return the maximum of the X coordinate.
* @return double, X maximum.
*/
// A FAIRE !!!! //
public double xmax() {return 0;};
}
