package opale.m2d.component2d;
import opale.tools.*;
import opale.m2d.*;
import java.awt.*;
import java.awt.event.*;

/**
* @since Opale-2d 0.11
*/
public class Frame2D extends Frame  
{
private Pack2D pack;
private	CoordSystem vue;
private	GAxis2D axes;
private  MenuBar menuBar1 = new MenuBar();
private  Menu menuFile = new Menu();
private  MenuItem menuFileExit= new Menu() ;
private  MenuItem menuFileClose= new Menu();
private  Menu menuEdition = new Menu();
private  MenuItem menuEditEchelle= new MenuItem();
private  MenuItem menuEditAxes= new MenuItem() ;

/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
*/
public Frame2D()
	{
	setTitle("Opale  - Frame 2d");
	setSize(300,300);
	setBackground(Color.white);	

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
		
	add(new DrawPanel(),"Center");	
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,300,300);

	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	}

public Frame2D(boolean type)
	{
	setTitle("Opale  - Frame 2d");
	setSize(300,300);
	setBackground(Color.white);	

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			dispose();
			}
		}
		);
if(type)
 {
 menuBar1 = new MenuBar();
 menuFile = new Menu();
 menuFileExit = new MenuItem();
 menuFileClose = new MenuItem();
 menuEdition = new Menu();
 menuEditEchelle = new MenuItem();	
    menuFile.setLabel("Fichier");
    menuFileClose.setLabel("Fermer");
    menuFileClose.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileClose_actionPerformed(e);
      }
    });
    menuFileExit.setLabel("Quitter");
    menuFileExit.addActionListener(new ActionListener()  {

      public void actionPerformed(ActionEvent e) {
        fileExit_actionPerformed(e);
      }
    });

    menuEdition.setLabel("Edition");
    menuEditEchelle.setLabel("Echelle");
    menuEditEchelle.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
     //   menuEditEchelle_actionPerformed(e);
      }
    });

    menuEditAxes.setLabel("Axes");
    menuEditAxes.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        menuEditAxes_actionPerformed(e);
      }
    });


    menuFile.add(menuFileClose);
    menuFile.add(menuFileExit);
    menuEdition.add(menuEditEchelle);
    menuEdition.add(menuEditAxes);
    menuBar1.add(menuFile);
    menuBar1.add(menuEdition);
    this.setMenuBar(menuBar1);
  }
		
	add(new DrawPanel(),"Center");	
	vue = new LinLinCS(OIJ.OIJ_ABSOLUTE,0,0,300,300);

	pack = new Pack2D();
	pack.add(OIJ.OIJ_ABSOLUTE,"oij_abs");
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	}

/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
*/
public Pack2D getPack2D()
	{
	return pack;
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.

*/
public GAxis2D getAxis()
	{
	return axes;
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
*/
public CoordSystem getCS()
	{
	return vue;
	}

private  void menuEditAxes_actionPerformed(ActionEvent e) { 
  	AxisEditor ed = new AxisEditor(this);
	ed.show();
	
	}
	
private   void fileClose_actionPerformed(ActionEvent e) {
    dispose();
  }
private   void fileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }
private class DrawPanel extends Panel
{
DrawPanel()
	{
	super.addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(0,0,DrawPanel.this.getWidth(),DrawPanel.this.getHeight());
			vue.autoadjust();
			DrawPanel.this.repaint();
			}
		});

	}

public void paint(Graphics g)
	{
	Pen2D c = new Pen2D(g,vue);
	axes.draw(c);
	c.clip();
		
	pack.draw(c);
	}

}



public static void main(String[] arg)
	{
	Frame2D f =new Frame2D(true);
	f.show();
	}
	
}


