/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.*;
/**
* Cette classe reprsente une fonction  paramtrique x(t), y(t).
* @since Opale-2d 0.11
* @author O.C.
*/

public class xyFt extends Object2D implements Cloneable
{
protected IxyFt fonc;
protected double tinf, tsup;
protected int N;


/**
* Constructeur par dfaut.
*/
public xyFt()
	{
	super();
	System.out.println("Dans xyFt()");
	N=2;
	tinf =0;
	tsup = 10;
        fonc = 	new IxyFt() 
				{ 
				public double x(double t) { return 0;}; 
				public double y(double t) { return 0;}; 
				};
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public xyFt(OIJ rep)
	{
	super(rep);
	N=2;
	tinf =0;
	tsup = 10;
        fonc = 	new IxyFt() 
				{ 
				public double x(double t) { return 0;}; 
				public double y(double t) { return 0;}; 
				};
	}


/**
* Le constructeur de copie
* @param xyFt d, l'objet  copier.
*/
public xyFt(xyFt f)
	{
	fonc=f.fonc;
	N = f.N;
	tinf=f.tinf;
	tsup=f.tsup;
	}

/**
* Fixe la fonction a tracer, les bornes de dfinition et le nombre de points.
* @param IxyFt f, la fonction  dessiner.
* @param double tinf, tsup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
*/
public void set(IxyFt f, double inf, double sup, int n)
	{
	N = Math.max(2,n); 
	fonc = f;
	if ( inf > sup )
		{
		tsup = inf;
		tinf = sup;
		}
	else
		{
		tsup = sup;
		tinf = inf;
		}
	}
	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	xyFt y = (xyFt) super.clone();
	return y;
	}

/**
* Effectue un changement de repere de l'objet.
* @param OIJ rep, le nouveau repere.
*/
public void changeOIJ(OIJ rep)
	{
	}
	
public void writeMore(PrintWriter f, OpaleSet p)
	{
	}	
	
public  int readKeyWord(String word, StreamTokenizer f, OpaleSet p) throws java.io.IOException, InvalidFormatException
	{
	return -1;
		
	}
	
public String toString()
	{
	String s="x(t),y(t)";
	return s;
	}
	
}
