/**
* Cette classe permet d'effctuer des calculs de statistiques de base
* sur un echantillon de donnes.
* @author K.D.
* @version 0.1
*/


public class Stat {
private    int dim;
private double x[];

/*
* Constructeur par dfaut qui initialise le tableau par des O.
*/
public Stat(int dim){
    double[] x = new double[dim];
    for(int i=0;i<dim;i++)
      x[i]=0;
    }
/*
* Constructeur  partir d'un echantillon existant.
*/
public Stat(Stat M){
   this.dim = M.dim;
   double[] x = new double[M.dim];
   for(int i=0;i<this.dim;i++)
     this.x[i] = M.x[i];
   }

/**
* Constructeur  partir d'un tableau de donnes.
*/
public Stat(double y[], int length){
    dim = length;
    for(int i=0;i<dim;i++)
      x[i] = y[i];
    }

/**
* Cette fonction calcul la moyenne d'une population.
* Indice de la tendance centrale.
*/
public double average(){
    double avg = 0;
    for(int i=0;i<this.dim;i++)
      avg += avg + this.x[i];
    avg = avg/this.dim;
    return avg;
    }

/**
* cette fonction calcul la variance d'une population.
* indice de la dispersion d'une population.
* les lments reprsentent la population entire.
*/
public double variance(){
    double vary = 0;
    for(int i=0;i<this.dim;i++)
      vary += Math.pow(this.x[i] - this.average(),2);
    vary = vary / this.dim;
    return vary;
    }

/**
*  cette fonction calcul la varaince d'un chantillon
* d'une population  l'aide de l'estimateur sans biais.
*/
public double variance_ech(){
    double vary;
    int n = this.dim;
    vary = (n / (n - 1)) * this.variance();
    return vary;
    }

/**
* Cette fonction calcul l'cart-type.
*/
public double ecartype(){
    double ecart;
    ecart = Math.sqrt(this.variance());
    return ecart;
    }

/**
* Cette fonction renvoie l'cart-type d'un chantillon.
*/
public double ecartype_ech(){
    double ecart;
    ecart = Math.sqrt(this.variance_ech());
    return ecart;
    }


/**
* cette fonction calcul la covariance.
* Elle reprsente le degr de dissociation entre deux populations.
* Les deux populations doivent la mme dimension.
*/
public double covariance(Stat M){
    double cov = 0;
    for(int i=0;i<M.dim;i++)
      cov += (this.x[i] - this.average())*(M.x[i] - M.average());
    cov = cov / M.dim;
    return cov;
    }

/** 
* Cette fonction calcul la corrlation.
* Elle ressemble  la covariance mais elle est comprise entre -1 et 1.
*/
public double correlation(Stat M){
    double cor;
    cor = this.covariance(M) / (this.ecartype() * M.ecartype());
    return cor;
    }

}