package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma d'Euler explicite qui consiste  avancer en temps de la facon suivante : yn+1=yn+f(t,yn).
* @author O.C.
* @since Opale-ODE 0.1
*/
public  final class ExplicitEuler extends TimeScheme
{
	
/**
* Cette mthode dfinit l'avanc en temps par la formule d'Euler Explicite.
*/	
public void forward(Equation eq)
	{
	int i;
	DVect der = eq.derivs(time(),present());
	for (i=0;i<present().size();i++)
		present().set(i,present().get(i)+dt()*der.get(i));
	}

public String toString()
	{
	return "Explicit Euler";
	}

}
