package opale.tools;
/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


/**
* This class makes it possible to check assertion in the programms. It's possible to use the conditionale compilation of javac compiler with testing the boolean <code>Assert.enabled</code> :
<p>
<code> if (Assert.enabled) Assert.check(i==0);</code>
<p> This class is compatible with the java spec 1.4 because of the keyword <code>assert</code> is not used.
* @since Opale-Tools 0.15
*/
public class Assert
{
/**
* <code>enabled = true</code> for the debugging mode.
*/
public final static boolean enabled = true;


/**
* Verify an assertion.
* @param boolean, an assert.
*/
public static void check(boolean i)
	{
	if (!i) throw new IllegalArgumentException("an assertion failed !!");
	}

}
