/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.tools;
import java.util.*;
import java.io.*;


/**
* This class contains methods to run one test case or all test cases.
* @date 03/03/2001
* @author O.C.
* @since Opale-Tools 0.12
*/

public class ORunTest
{
public static String separator = System.getProperty("file.separator");
public static String OPALE_DIR;
public static int NTEST=0;
public static int NGOOD=0;
public static Vector nosuccessful=new Vector();
public static java.io.PrintStream TestERR;
public static java.io.PrintStream TestOUT;
public static WFile TestLOG;
/**
* Extract all tests files.
*/
private static ListOfTest[] find_alltests()
	{
	Vector list_temp = new Vector();
	File f = new File(OPALE_DIR+separator+"otests"+separator);
	String[] li = f.list();
	for (int i=0;i<li.length;i++)
		{
		ListOfTest temp;
		//System.out.println(li[i]);
		File f2 = new File(OPALE_DIR+separator+"otests"+separator+li[i]);
		if (f2.isDirectory()) 
			{
			list_temp.add(temp = new ListOfTest(li[i]));
			String[] lis_test = f2.list();
			for (int j=0;j<lis_test.length;j++)
				{
				//System.out.println(lis_test[j]);
				temp.add(lis_test[j]);
				NTEST++;
				}
			}
		}
	Object[] aaa = list_temp.toArray();	
	ListOfTest[] list = new ListOfTest[aaa.length];
	for (int i=0;i<list.length;i++)
		list[i] = (ListOfTest) aaa[i];
	return list;
	}
	
/**
* Run all tests.
*/
private static void runalltest()
	{
	String resu;
	ListOfTest[] list = ORunTest.find_alltests();
	for (int i=0;i<list.length;i++)
		{
		TestLOG.println("\n******************");
		TestLOG.println(list[i].name_mod);
		TestLOG.println("******************\n");
		for (int j=0;j<list[i].name_tests.size();j++)
			{
			try
			{
			TestLOG.print("-->>>> "+list[i].name_tests.get(j)+" ");
			ORunTest.runtest((String) list[i].name_mod,(String)list[i].name_tests.get(j));
			//OpaleObject.cleanGlobalSet();
			resu =" OK !";
			}
/*	catch(ClassNotFoundException evt)
		{
		}
	catch(InstantiationException evt)
		{
		}
	catch(IllegalAccessException evt)
		{
		}*/
			catch (Exception evt)
				{
				TestLOG.println(" fails !\n"+evt);
				NGOOD--;
				nosuccessful.add("otests."+(String) list[i].name_mod+"."+list[i].name_tests.get(j));
				resu = "";
				}
			catch (Error evt)
				{
				TestLOG.println(" fails !\n"+evt);
				NGOOD--;
				nosuccessful.add("otests."+(String) list[i].name_mod+"."+list[i].name_tests.get(j));
				resu = "";
				}
			TestLOG.println(resu);
			NGOOD++;
			}
		}
	
	}
	

/**
* Run the specified test 'nomtest' in the package 'paquet'.
* @param String paquet, the directory that contains the test
* @param String nomtest, the name of the test
*/
private static void runtest(String paquet, String nomtest) throws ClassNotFoundException,InstantiationException,IllegalAccessException
	{
	String PATH=OPALE_DIR+separator+"otests"+separator+paquet+separator+nomtest+separator;
	Class tes = Class.forName("otests."+paquet+"."+nomtest+"."+nomtest);
	OTest thetest = (OTest) tes.newInstance();
	thetest.run(PATH);
	thetest.stop();
	}
	
	
public static void  main(String[] arg)
	{
	try{
	PrintStream old_out = System.out;
	OPALE_DIR=System.getProperty("OPALE_DIR");
	if (OPALE_DIR==null) 
		{
		System.err.println("OPALE_DIR NOT INITIALIZED !!");
		System.exit(-1);
		}

	TestERR = new PrintStream(new FileOutputStream(OPALE_DIR+separator+"otests"+separator+"Test.err"));
	TestOUT = new PrintStream(new FileOutputStream(OPALE_DIR+separator+"otests"+separator+"Test.out"));
	TestLOG = new WFile(OPALE_DIR+separator+"otests"+separator+"Test.log");
	System.setErr(TestERR);
	System.setOut(TestOUT);
	TestLOG.println("=================\n OPALE TESTS \n================= \n");
	runalltest();
//	for (int i=0;i<nosuccessful.size();i++)
//		TestLOG.println(nosuccessful.get(i)+" fails !");
	TestLOG.println("\n Successful : "+NGOOD+"/"+NTEST);
	TestLOG.println("\n=================\n End Of Tests \n================= \n");

	TestLOG.close();
	
	System.setOut(old_out);
	System.out.println("\n Successful cases : "+NGOOD+"/"+NTEST);
	System.exit(-1);
	}
	catch (FileNotFoundException evt)
		{
		}
	catch (IOException evt)
		{
		}
		
	}
	
	
	
}

class ListOfTest
{
String name_mod;
Vector name_tests;

ListOfTest(String name_mod)
	{
	this.name_mod = name_mod;
	name_tests = new Vector();
	}
	
void add(String test)
	{
	name_tests.add(test);
	}
}
