package opale.tools;
import java.util.*;
import java.io.*;

/**
* This class represents a group of Opale object. It makes it possible to store these objects attributing them an identificator and it is also possible to read/write them in a stream.
* @author O.C.
* @since Opale-tools 0.14 (OpaleV1b5)
*/
public class OpaleSet
{
private HashMap obj;
private HashMap prior;
private static HashMap objectName,userName; 	//liste des correspondances entre noms des classes des objets et leurs noms utilisateurs ncssaires pour la lecture/ecriture des fichiers de donnes.

/**
* Construct a new OpaleSet.
*/
public OpaleSet()
	{
	if (Debug.On) Stdio.printerrln("New OpaleSet");
	obj = new HashMap();
	
	objectName = new HashMap();
	userName = new HashMap();
	prior = new HashMap();
	int type;
	String nomClasse="", nomUser="";
	
	try
	{
	java.io.InputStream in = getClass().getResourceAsStream("name_object.rsc");
	StreamTokenizer rf=null;
	if (in != null)
		{
		java.io.Reader r = new java.io.BufferedReader(new java.io.InputStreamReader(in));
		rf = new StreamTokenizer(r);
		}
	else
		{
		System.err.println("File name_object.rsc not found.");
		System.err.println("Stop.");
		System.exit(-1);
		}
	rf.wordChars(33,255);
	type = rf.nextToken();
	while(type != StreamTokenizer.TT_EOF)
		{
		if (type == StreamTokenizer.TT_NUMBER)
			nomClasse = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomClasse = rf.sval;
		type = rf.nextToken();
		if (type == StreamTokenizer.TT_NUMBER)
			nomUser = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomUser = rf.sval;
		else if (type == StreamTokenizer.TT_EOF)
			{
			System.err.println("Error reading file of configuration.\n Stop.");
			System.exit(-1);
			}
		type = rf.nextToken();
		if (type != StreamTokenizer.TT_NUMBER)
			{
			System.err.println("Error reading file of configuration.\n Stop.");
			System.exit(-1);
			}
		else 
			{
			prior.put(nomClasse,new Double(rf.nval));
			}
					
		objectName.put(nomUser,nomClasse);
		userName.put(nomClasse,nomUser);
		type = rf.nextToken();
		}
	}
	catch(java.io.IOException e)
		{
		System.err.println("Error reading file of configuration.\n Stop.");
		System.err.println(e);
		System.exit(-1);
		}
	if (Debug.On) System.err.println(objectName);
	if (Debug.On) System.err.println(userName);
	if (Debug.On) System.err.println(prior);
	
	
	}

/**
* Add a new Opale object. If the object hasn't an identificator (<code>setId</code> in the class OpaleObject) then this method throw an instance of the runtime exception <code> InvalidIdException</code>.
* @param OpaleObject, the object to add.
*/
public void add(OpaleObject o) 
        {
        if (o.getId()==null) throw new InvalidIdException("An Opale object must have an identificator before to be added in an Opale set !!!");
	obj.put(o.getId(),o);
        }

/**
* Add a new Opale object specifying its id. If the id specified is null then this method throw an instance of the runtime exception <code> InvalidIdException</code>. If the object has already an id, it is added with its id.
* @param OpaleObject, the object to add.
* @param String, its id.
*/
public void add(OpaleObject o,String id) 
        {
        if (id==null) throw new InvalidIdException("An Opale object must have a non null identificator !!!");
	o.setId(id);
	obj.put(o.getId(),o);
        }

/**
* Removes all Opale object of this set.
*/
public void clear() { obj.clear(); }


/**
*
*/
public int size() { return obj.size(); }


/**
*
*/
public void remove(String id) { obj.remove(id); }

/**
*
*/
public Collection objects() { return obj.values(); }


/**
*
*/
public OpaleObject getObject(String id)
        {
        return (OpaleObject) obj.get(id);
	}

/**
*/
public boolean contains(OpaleObject o)
        {
        return obj.containsValue(o);
        }

/**
*
*/
public boolean contains(String id)
        {
        return obj.containsKey(id);
        }

/**
*/
public boolean isEmpty()
	{
	return obj.isEmpty();
	}
	

/**
* Renvoie un tableau de String qui contient tous les noms utilisateurs des
objets.
* @return String[] le tableau de noms.
*/
public String[] getUserNameObject()
	{
	Object[] lobj = objectName.keySet().toArray();
	String[] list = new String[objectName.size()];
	int i;
	
	for (i=0;i<objectName.size();i++)
		list[i] = (String) lobj[i];
	return list;
	}
	/**
* Renvoie le nom de la classe d'un objet  OpaleObject  partir de son nom
utilisateur.
* @return String le nom de la classe.
* @param String le nom utilisateur.
*/ 	
public String getNameObject(String username)
	{
	return (String) objectName.get(username);
	}
	
	
/**
* Renvoie le nom utilisateur d'une classe d'un objet Object  partir de son
nom de classe en Java.
* @param String le nom de la classe.
* @return String le nom utilisateur.
*/ 	
public String getUserName(String objname)
	{
	return (String) userName.get(objname);
	}


/**
* Reads a set of  Opale objects in a stream.
* @param Reader r, an Reader object to read.
*/
public void read(Reader r) throws InvalidFormatException
	{
	int type;
	BufferedReader br = new BufferedReader(r,5000);
	StreamTokenizer f = new StreamTokenizer(br);
	f.wordChars(33,255);
	f.slashStarComments(false);
	f.slashSlashComments(true);
	Stdio.println("Reading the stream : "+br);
	//Stdio.println("Reading the stream : "+br.markSupported());
	
	try
	{
	br.mark(5000);

	Stdio.println(" ->> Reading the declarations & definitions");

	type = f.nextToken();
	while (type != StreamTokenizer.TT_EOF)
		{
			if (Debug.On) Debug.print("->> Read an object of type "+f.sval+".");
			/*if (getNameObject(f.sval) == null) 
				{
				Stdio.printerrln("Error reading the file " + f);
				Stdio.printerrln("It is not possible to indentify the type  "+f.sval+".\nStop.");
				System.exit(-1);
				}*/
			if (getNameObject(f.sval)== null) throw new InvalidFormatException("Unknown type "+f.sval+" !!!");
			OpaleObject ob =  (OpaleObject) Class.forName(getNameObject(f.sval)).newInstance();
			f.nextToken();	//on lit l'id
			String id = f.sval;
			if (Debug.On) Debug.print("id = ",id);
			ob.setId(id);
			//type = jump(f);
			ob.read(f,this);
			this.add(ob);
			if (Debug.On) Debug.print("->> End of reading an object.");

			 
		type = f.nextToken();
		}
		
/*	Stdio.println(" ->> Pass 2 : reading the definitions");

	br.reset();
	//br = new BufferedReader(r);
	f = new StreamTokenizer(br);
	f.wordChars(33,255);
	f.slashStarComments(false);
	f.slashSlashComments(true);
	type = f.nextToken();
	while (type != StreamTokenizer.TT_EOF)
		{
			if (Debug.On) Debug.print("->> Read an object of type "+f.sval+".");
			if (getNameObject(f.sval) == null) 
				{
				Stdio.printerrln("Error reading the file " + f);
				Stdio.printerrln("It is not possible to indentify the type  "+f.sval+".\nStop.");
				System.exit(-1);
				}
			if (getNameObject(f.sval)== null) throw new InvalidFormatException("Unknown type "+f.sval+" !!!");
//			OpaleObject ob =  (OpaleObject) Class.forName(getNameObject(f.sval)).newInstance();
			f.nextToken();	//on lit l'id
			String id = f.sval;
			if (Debug.On) Debug.print("id = ",id);
			getObject(id).read(f,this);
			
			if (Debug.On) Debug.print("->> End of reading an object.");

			 
		type = f.nextToken();
		}*/
	}
	catch (java.io.IOException e)
	{
	System.err.println("Error reading the file " + f);
	System.err.println(e);
	System.exit(-1);
	}	
	catch(ClassNotFoundException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : the class does not exist.");
	}
	catch(IllegalAccessException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : access to the class not possible.");
	}
	catch(InstantiationException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : class not instantiable.");
	}
	}
	


/**
* Reads a set of  Opale objects in a stream.
* @param StreamTokenizer f, a StreamTokenizer object to read.
*/
public void read(StreamTokenizer f) throws InvalidFormatException
	{
	int type;
	Stdio.println("Reading the stream : "+f);
	
	try
	{

	type = f.nextToken();
	while (type != StreamTokenizer.TT_EOF)
		{
			if (Debug.On) Debug.print("->> Read an object of type "+f.sval+".");
			/*if (getNameObject(f.sval) == null) 
				{
				Stdio.printerrln("Error reading the file " + f);
				Stdio.printerrln("It is not possible to indentify the type  "+f.sval+".\nStop.");
				System.exit(-1);
				}*/
			if (getNameObject(f.sval)== null) throw new InvalidFormatException("Unknown type "+f.sval+" !!!");
			OpaleObject ob =  (OpaleObject) Class.forName(getNameObject(f.sval)).newInstance();
			f.nextToken();	//on lit l'id
			String id = f.sval;
			if (Debug.On) Debug.print("id = ",id);
			ob.setId(id);
			//type = jump(f);
			ob.read(f,this);
			this.add(ob);
			if (Debug.On) Debug.print("->> End of reading an object.");

			 
		type = f.nextToken();
		}
		

	}
	catch (java.io.IOException e)
	{
	System.err.println("Error reading the file " + f);
	System.err.println(e);
	System.exit(-1);
	}	
	catch(ClassNotFoundException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : the class does not exist.");
	}
	catch(IllegalAccessException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : access to the class not possible.");
	}
	catch(InstantiationException exc)
	{
	throw new InvalidFormatException("Error reading an object of type "+f.sval+" : class not instantiable.");
	}
	}
	


/**
* Write the objects contained in this class.
* @param PrintWriter f, a stream.
*/
public void write(PrintWriter f) throws InvalidFormatException
	{
	if (isEmpty())
		{
		throw new IllegalArgumentException("No objects to write !!!");
		} 
//	int i;



	Comparator comp = new Comparator()
		{
		public int compare(Object o1, Object o2)
			{
			OpaleObject op1 = (OpaleObject) o1;
			OpaleObject op2 = (OpaleObject) o2;
			System.out.println(op1.getClass().getName());
			double p1 = ((Double)prior.get(op1.getClass().getName())).doubleValue();
			double p2 = ((Double)prior.get(op2.getClass().getName())).doubleValue();
			if (p1 < p2 )
				return -1;
			else if (p1 == p2 )
				return 0;
			else return 1;
			
			}
		
		};


	OpaleObject[]  opobj = (OpaleObject[]) this.objects().toArray(new OpaleObject[0]);
	Arrays.sort(opobj,comp);

	/*Collection col = this.objects();
	Iterator it = col.iterator();
	while (it.hasNext())
		{
		OpaleObject obj = (OpaleObject) it.next();
		f.print(getUserName(obj.getClass().getName())+" ");
		f.println(obj.getId());
		obj.write(f,this);
		f.println("");
		}*/
	for (int i = 0;i<opobj.length;i++)
		{
		f.print(getUserName(opobj[i].getClass().getName())+" ");
		f.println(opobj[i].getId());
		opobj[i].write(f,this);
		f.println("");
		}	
	}


private int jump(StreamTokenizer f) throws InvalidFormatException
	{
	try
	{
	Stack pile = new Stack();
	int type;
	
	type = f.nextToken();	//on lit une '{' en principe...
	if (Debug.On) Debug.print(f.sval);
	if ( (type !=StreamTokenizer.TT_WORD) || (!f.sval.equals("{")) ) throw new InvalidFormatException("Syntax error : '{' expected !!");
	pile.push("{");
	type = f.nextToken();	
	while ( (!pile.empty()) && (type != StreamTokenizer.TT_EOF))
		{
		if ( (type == StreamTokenizer.TT_WORD) && (f.sval.equals( "{")) ) 
			{
			if (Debug.On) Debug.print(" > We push {");
			pile.push("{");
			}
		else if	 ( (type == StreamTokenizer.TT_WORD) && (f.sval.equals( "}")) )
			{
			if (Debug.On) Debug.print(" > Pop }");
			if (pile.empty()) throw new InvalidFormatException(" Syntax error : '{' expected !!!");
			else 
				{
				String s = (String) pile.pop();
				if (!s.equals("{"))  throw new InvalidFormatException(" Syntax error : '{' expected !!!");
				}
			}
			
		type = f.nextToken();
		}
	
	if (Debug.On) Debug.print("Stack at the end : "+pile);
	return type;
	}
	catch (java.io.IOException e)
	{
	System.err.println("Error reading the file " + f);
	System.err.println(e);
	System.exit(-1);
	}
	return 0;	
	}

public void check()
	{
        System.err.println("Check OpaleSet : ");
        System.err.println(" "+obj);
	}	

}

