/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.tools;
import java.io.*;
/**
* Cette classe encapsule des methodes pour ecrire les types de base de Java dans un fichier sous forme ASCII.
* @since Opale-Tools 0.1
* @author O.C.
*/

public class WFile extends PrintWriter
{
private String name;
//private PrintWriter out;

/**
* constructeur qui prend en argument le nom du fichier  ouvrir en ecriture.
* @param String name, le nom du fichier.
*/
public WFile(String name) throws IOException
	{
	super(new FileWriter(name));
	this.name = name;
	}	

/**
* constructeur qui prend en argument le nom du fichier  ouvrir en ecriture, et
le mode de vidage(automatique ou non).
* @param String name, le nom du fichier.
* @param boolean auto, true=autoFlush.
*/
public WFile(String name, boolean auto) throws IOException
	{
	super(new FileWriter(name),auto);
	this.name = name;
	}	

public void writeInt(int n)
	{
	print(n);
	print(" ");
	}

public void writeDouble(double x)
	{
	print(x);
	print(" ");
	}

public void writeFloat(float x)
	{
	print(x);
	print(" ");
	}

public void writeChar(char c)
	{
	print(c);
	print(" ");
	}

public void writeString(String s)
	{
	print(s);
	print(" ");
	}

public void writelnInt(int n)
	{
	println(n);
	}

public void writelnDouble(double x)
	{
	println(x);
	}

public void writelnFloat(float x)
	{
	println(x);
	}

public void writelnChar(char c)
	{
	println(c);
	}

public void writeln(String s)
	{
	println(s);
	}

protected void finalize() 
	{
	close();
	}


public String toString()
	{
	return name;
	}
	

}
