import opale.tools.*;
import opale.mathtools.*;
import opale.ode.*;
import opale.ode.scheme.*;
import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.component2d.*;


public class Implicit
	{
	
	public static void main(String[] arg)
	{
	final int DT=31;
	// Rsolution des problmes de Vander Pool avec 15 conditions initiales diffrentes

	Problem pb = new Problem(1);	//problme en dimension 2
	ImplicitEuler ts = new ImplicitEuler();		// avec la mthode de RungeKutta classique
	//ThetaScheme ts = new ThetaScheme();		
	DVect cd = new DVect(1);	// vecteur pour la condition initiale
	
	ts.setNstep(DT);		//nombre de pas en temps : DT0
	ts.set(0,10);			// tude sur l'intervalle en temps (0;10)
	pb.setEqn(			//on dfinit l'equation du systme 
		new Equation()
			{
			DVect y = new DVect(1);
			public int dim() { return 1; }
			public DVect derivs(double t, DVect x)
				{
				y.set(0,-x.get(0));		
				return y;
				}
			}
		);
	double[][] sol = new double[2][DT];

	pb.setTS(ts);	//on associe le schma en temps
	
		cd.set(0,1);
		pb.setInit(cd);
		pb.solve();
		sol=pb.toArray();
	
	
	
	// On affiche le rsultat avec le module 2d d'Opale
	JFrame2D jf = new JFrame2D();
	jf.setTitle("Systme de Van der Pol - Opale-ODE 0.1");
	jf.setSize(600,600);
	jf.getAxis().drawScale(false);
	OIJ repere = new OIJ();
	jf.getCS().set(-1,12,-1.5,1.5);
	jf.getPack2D().add(repere,"repere");
	GData2D gsol = new GData2D(repere);
	//chaque solution est reprsente par un objet de type GData2D (nuage de points)
	
	
	//affichage 
		gsol.set(DT,sol[0],sol[1]);
		jf.getPack2D().add(gsol,"sol");
		
	jf.show();
	
	
	
	}

}
