/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import java.io.PrintWriter;
import opale.m2d.OIJ;
import opale.m2d.Object2D;
import opale.m2d.Point2D;
import opale.m2d.Vector2D;
import opale.m2d.object2d.LineException;
import opale.tools.InvalidFormatException;
import opale.tools.OpaleSet;
import opale.tools.StreamReader;

public class Line2D
extends Object2D
implements Cloneable {
    public static final double EPSILON = 1.0E-15;
    protected double a;
    protected double b;
    protected double c;

    public Line2D() {
    }

    public Line2D(Line2D line2D) {
        super(line2D.getOIJ());
        this.a = line2D.a;
        this.b = line2D.b;
        this.c = line2D.c;
    }

    public Line2D(OIJ oIJ, double d, double d2, double d3) throws LineException {
        super(oIJ);
        if (Math.abs(d) <= 1.0E-15 && Math.abs(d2) <= 1.0E-15 && Math.abs(d3) > 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0, avec c<>0");
        }
        this.a = d;
        this.b = d2;
        this.c = d3;
    }

    public Line2D(OIJ oIJ, double d, double d2, double d3, double d4) throws LineException {
        super(oIJ);
        this.a = d4 - d2;
        this.b = d - d3;
        this.c = d3 * d2 - d * d4;
        if (Math.abs(this.a) <= 1.0E-15 && Math.abs(this.b) <= 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0");
        }
    }

    public Line2D(Point2D point2D, Point2D point2D2) throws LineException {
        super(point2D.getOIJ());
        Point2D point2D3 = (Point2D)point2D2.clone();
        point2D3.changeOIJ(point2D.getOIJ());
        this.a = point2D3.getY() - point2D.getY();
        this.b = point2D.getX() - point2D3.getX();
        this.c = point2D3.getX() * point2D.getY() - point2D.getX() * point2D3.getY();
        if (Math.abs(this.a) <= 1.0E-15 && Math.abs(this.b) <= 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0");
        }
    }

    public Line2D(Point2D point2D, Vector2D vector2D) {
        super(point2D.getOIJ());
        Vector2D vector2D2 = (Vector2D)vector2D.clone();
        vector2D2.changeOIJ(point2D.getOIJ());
        this.a = vector2D2.getY();
        this.b = -vector2D2.getX();
        this.c = vector2D2.getX() * point2D.getY() - point2D.getX() * vector2D2.getY();
    }

    public void set(double d, double d2, double d3) throws LineException {
        if (Math.abs(d) <= 1.0E-15 && Math.abs(d2) <= 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0");
        }
        this.a = d;
        this.b = d2;
        this.c = d3;
    }

    public void set(double d, double d2, double d3, double d4) throws LineException {
        double d5 = d4 - d2;
        double d6 = d - d3;
        double d7 = d3 * d2 - d * d4;
        if (Math.abs(d5) <= 1.0E-15 && Math.abs(d6) <= 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0");
        }
        this.a = d5;
        this.b = d6;
        this.c = d7;
    }

    public void set(Point2D point2D, Point2D point2D2) throws LineException {
        Point2D point2D3 = (Point2D)point2D.clone();
        Point2D point2D4 = (Point2D)point2D2.clone();
        point2D3.changeOIJ(this.getOIJ());
        point2D4.changeOIJ(this.getOIJ());
        double d = point2D4.getY() - point2D3.getY();
        double d2 = point2D3.getX() - point2D4.getX();
        double d3 = point2D4.getX() * point2D3.getY() - point2D3.getX() * point2D4.getY();
        if (Math.abs(d) <= 1.0E-15 && Math.abs(d2) <= 1.0E-15) {
            throw new LineException("Impossible de construire une droite d'\u00e9quation c = 0");
        }
        this.a = d;
        this.b = d2;
        this.c = d3;
    }

    public void set(Line2D line2D) {
        this.setOIJ(line2D.getOIJ());
        this.a = line2D.a;
        this.b = line2D.b;
        this.c = line2D.c;
    }

    public final double get(int n) {
        if (n == 0) {
            return this.a;
        }
        if (n == 1) {
            return this.b;
        }
        if (n == 2) {
            return this.c;
        }
        return -1.0;
    }

    public void orthoLine(double d, double d2, Line2D line2D) {
        try {
            line2D.setOIJ(this.getOIJ());
            line2D.set(-this.b, this.a, this.b * d - this.a * d2);
        }
        catch (LineException lineException) {
            System.out.println("Dans Line2D.java::orthoLine()  Ne devrait jamais arriver !");
            System.exit(-1);
        }
    }

    public void orthoLine(Point2D point2D, Line2D line2D) {
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.changeOIJ(this.getOIJ());
        try {
            line2D.setOIJ(this.getOIJ());
            line2D.set(-this.b, this.a, this.b * point2D2.getX() - this.a * point2D2.getY());
        }
        catch (LineException lineException) {
            System.out.println("Dans Line2D.java::orthoLine()  Ne devrait jamais arriver !");
            System.exit(-1);
        }
    }

    public void parallLine(double d, double d2, Line2D line2D) {
        try {
            line2D.setOIJ(this.getOIJ());
            line2D.set(this.a, this.b, -this.a * d - this.b * d2);
        }
        catch (LineException lineException) {
            System.out.println("Dans Line2D.java::parallLine()  Ne devrait jamais arriver !");
            System.exit(-1);
        }
    }

    public void parallLine(Point2D point2D, Line2D line2D) {
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.changeOIJ(this.getOIJ());
        try {
            line2D.setOIJ(this.getOIJ());
            line2D.set(this.a, this.b, -this.a * point2D2.getX() - this.b * point2D2.getY());
        }
        catch (LineException lineException) {
            System.out.println("Dans Line2D.java::parallLine()  Ne devrait jamais arriver !");
            System.exit(-1);
        }
    }

    public Vector2D orthoVect() {
        return new Vector2D(this.getOIJ(), this.a, this.b);
    }

    public final Vector2D dirVect() {
        return new Vector2D(this.getOIJ(), -this.b, this.a);
    }

    public double distSq(double d, double d2) {
        double d3 = this.dirVect().norm();
        if (d3 > 1.0E-15) {
            return Math.abs(this.a * d + this.b * d2 + this.c) / d3;
        }
        return -1.0;
    }

    public double distSq(Point2D point2D) {
        double d = this.dirVect().norm();
        Point2D point2D2 = (Point2D)point2D.clone();
        point2D2.changeOIJ(this.getOIJ());
        if (d > 1.0E-15) {
            return Math.abs(this.a * point2D2.getX() + this.b * point2D2.getY() + this.c) / d;
        }
        return -1.0;
    }

    public final boolean isParall(Line2D line2D) {
        return Math.abs(this.a * line2D.b - this.b * line2D.a) <= 1.0E-15;
    }

    public final boolean isOrtho(Line2D line2D) {
        return Math.abs(this.a * line2D.a + this.b * line2D.b) <= 1.0E-15;
    }

    public Object clone() {
        Line2D line2D = (Line2D)super.clone();
        line2D.a = this.a;
        line2D.b = this.b;
        line2D.c = this.c;
        return line2D;
    }

    public boolean equals(Object object) {
        if (object instanceof Line2D) {
            Line2D line2D = (Line2D)object;
            return Math.abs(this.a * line2D.b - line2D.a * this.b) <= 1.0E-15 && Math.abs(this.c * line2D.b - line2D.c * this.b) <= 1.0E-15 && this.getOIJ().equals(line2D.getOIJ());
        }
        return false;
    }

    public void changeOIJ(OIJ oIJ) {
        Vector2D vector2D = this.dirVect();
        Point2D point2D = new Point2D(this.getOIJ());
        if (Math.abs(this.a) > 1.0E-15) {
            point2D.setLocation(-this.c / this.a, 0.0);
        } else if (Math.abs(this.b) > 1.0E-15) {
            point2D.setLocation(0.0, -this.c / this.b);
        }
        vector2D.changeOIJ(oIJ);
        point2D.changeOIJ(oIJ);
        try {
            this.set(point2D.getX(), point2D.getY(), point2D.getX() + vector2D.getX(), point2D.getY() + vector2D.getY());
        }
        catch (LineException lineException) {
            System.out.println("Dans Line2D.java::changeOIJ()  Ne devrait jamais arriver !");
            System.exit(-1);
        }
        this.setOIJ(oIJ);
    }

    public String toString() {
        return "Droite: " + this.a + "x + " + this.b + "y + " + this.c + " = 0";
    }

    public void writeMore(PrintWriter printWriter, OpaleSet opaleSet) throws InvalidFormatException {
        printWriter.println("a " + this.a);
        printWriter.println("b " + this.b);
        printWriter.println("c " + this.c);
    }

    public void read(StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        super.read(streamReader, opaleSet);
        try {
            this.set(this.a, this.b, this.c);
        }
        catch (LineException lineException) {
            throw new InvalidFormatException("Impossible de construire la droite " + this);
        }
    }

    public int readKeyWord(String string, StreamReader streamReader, OpaleSet opaleSet) throws IOException, InvalidFormatException {
        if (string.equals("a")) {
            this.a = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("b")) {
            this.b = streamReader.nextDouble();
            return 0;
        }
        if (string.equals("c")) {
            this.c = streamReader.nextDouble();
            return 0;
        }
        return -1;
    }
}

