/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

package otests.mathtools.Function;
import opale.mathtools.*;
import opale.tools.*;

public class Function implements OTest
{
public void run(String path)
	{
	AnalyticalFunction f = new AnalyticalFunction();
	f.setFunc("2*x");
	for (int i=0;i<10;i++)
		{
		double x = 1.5*i;
		System.out.println(f.val(x));
		}
	
	
	try {
	OpaleSet set = new OpaleSet();
	set.add(f,"function");
	WFile wf = new WFile(path+"wf.txt");
	set.write(wf);
	wf.close();
	
	set.clear();
	StreamReader rf= new StreamReader(path+"wf.txt");
	set.read(rf);
	AnalyticalFunction ff = (AnalyticalFunction) set.getObject("function");
	for (int i=0;i<10;i++)
		{
		double x = i;
		System.out.println(ff.val(x));
		}
	
	
	}
	catch(java.io.IOException evt)
		{
		System.err.println(evt);
		}
	catch(opale.tools.InvalidFormatException evt)
		{
		System.err.println(evt);
		}
	}	
public void stop() {};
}
