/*
 * OPALE is a scientific library under LGPL. Its main goal is to
 * develop mathematical tools for any scientist.
 *
 * Copyright (C) 2002 Opale Group
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 * 
 * You can visit the web site http://opale.tuxfamily.org to obtain more
 * informations about this program and/or to contact the authors by mail
 * developers@opale.tuxfamily.org.
 */

import opale.m2d.*;
import opale.m2d.object2d.*;
import opale.m2d.marktype.*;
import java.awt.*;
import java.awt.event.*;


public class pointvect extends Frame
	{
	OIJ repere;
	LinLinCS vue;
	GAxis2D axes;
	GPoint2D[] tabPoint;
	GVector2D[] tabVect;
	
	public pointvect() 
		{
		setSize(400,400);
		
		repere = new OIJ();
		vue = new LinLinCS(repere,25,25,350,350);
		
		axes = new GAxis2D(vue);
		((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
		
		tabPoint = new GPoint2D[10];
		tabVect = new GVector2D[5];

		int i;
		DefaultGraphicalOptions infopt;
		InfoVector infovct;
		Color color;
		for (i=0;i<10;i++)
			{
			tabPoint[i] = new GPoint2D(repere,-10+Math.random()*15,-10+Math.random()*15);
		DiamondPoint dp = new DiamondPoint();
		dp.setMarksize(10);
			infopt = (DefaultGraphicalOptions) tabPoint[i].getInfo();
		infopt.setMarktype(dp);
			color= new Color((int)  (Math.random()*200),(int)  (Math.random()*200),(int)  (Math.random()*200));
			infopt.setColor(color);
			}
		for (i=0;i<5;i++)
			{
			tabVect[i] = new GVector2D(repere,-10+Math.random()*15,-10+Math.random()*15);
			infovct = (InfoVector) tabVect[i].getInfo();
			infovct.setSymbol((int) (Math.random()*9));
			infovct.setSize(20);
			color= new Color((int)  (Math.random()*200),(int)  (Math.random()*200),(int)  (Math.random()*200));
			infovct.setColor(color);
			}
			

		addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(25,25,getWidth()-50,getHeight()-50);
			vue.normadjust();
			repaint();
			}
		});
		
		
		}
		
	public void paint(Graphics g)
		{
		int i;
		
		Pen2D c = new Pen2D(g,vue);
		axes.draw(c);
		
		for (i=0;i<10;i++)
			{
			tabPoint[i].draw(c);
			}
		for (i=0;i<5;i++)
			{
			tabVect[i].draw(c);
			}
		}
		
		
	
	
	
	public static void main(String[] arg) 		{
		pointvect t = new pointvect();
		t.show();
		}
	}
